Morgan Flanagan-Folcarelli
Weekend Wellness: Tips for Starting the Second Half of 2021 Mindfully
Updated: Jun 30
Here in Connecticut, we have a weekend of warm weather and sunshine ahead of us as we close out the month of June. With July approaching and the first six months of 2021 behind us, this weekend provides an opportunity to reflect and reset as we move forward into the second half of the year. But any time can be ripe for reflection if one chooses to take it! With that in mind, if you are looking for ways to approach the next couple of days with purpose, here are several things you can do this weekend—or any time you like—to set the tone for a mindful rest of the year.
Take a Mindful Hike or Walk
Research has established that spending time outdoors provides a multitude of benefits for one’s mental health. In a 2020 feature from the APA’s Monitor on Psychology, Kristen Weir summarizes several key points about the impact of nature on our wellbeing:
Spending time in nature is linked to both cognitive benefits and improvements in mood, mental health and emotional well-being.
Feeling connected to nature can produce similar benefits to well-being, regardless of how much time one spends outdoors.
Both green spaces and blue spaces (aquatic environments) produce well-being benefits. More remote and biodiverse spaces may be particularly helpful, though even urban parks and trees can lead to positive outcomes.
One simple way to harness the power of these benefits is to get outside on a hike or walk. Visiting a local city or state park can be a meaningfully immersive experience, but even taking a walk through your neighborhood can help connect you with nature.
To take your outdoor excursion to the next level, consider going on a mindful hike. This piece from Mindful.org provides a helpful guide hiking mindfully, but don’t be intimidated—taking a mindful hike doesn’t involve any special skills or practices. Instead, it simply requires some additional intentionality about things you are likely already doing: engaging your senses of sight, hearing, touch, and taste; pausing; moving in silence; and noticing the experiences that draw you in along the way.
Do Some Gratitude Journaling
Whether you are a journaling pro or have never journaled before, gratitude journaling can be a wonderful practice to add to your routine. Greater Good in Action, a project of the Greater Good Science Center at UC Berkeley and HopeLab, offers many simple, research-based practices to promote a “happier, more meaningful life”—and gratitude journaling is one of them. Their guide to gratitude journaling is clear and concise, and they recommend only taking 10-15 minutes once a week to enjoy the benefits of this practice. While I highly recommend clicking through the link above to read their nine tips and explore some of the other resources included alongside them, the following “How-to” from the page highlights how simple this practice can.
Start your day with a Coffee/Tea Meditation
If adding a new activity or practice to your weekend feels like too much, consider using something that’s already a part of your routine as a jumping-off point. For those of us who start our mornings with a cup of coffee (or tea), this could be as simple as taking some special time with our morning beverage. In her thoughtful blog post on the topic, writer Beth Bruno remarks, "Most of us start our mornings rushing around, caught up in our thoughts about all we have to do and feeling frazzled trying to get out the door. What if you could change that pattern simply by paying attention to your morning brew?"
Bruno walks through some simple steps to set aside external distractions and be attentive to the taste, smell, and feel of sitting and drinking your cup of coffee, ending the practice with an intention, wish, prayer, or positive affirmation.
Pick Up a New Book
In a previous post for The Consortium Speaks, I wrote about bibliotherapy and my experience of the connection between reading and mental health. Blogger Katie Martinez shares her perspective on mental health and reading in a post at Step Up for Mental Health, a peer-to-peer advocacy group providing support, assistance, and education. In her piece, she highlights the role reading can play in stress-reduction, improving sleep quality, and lowering heart rate and blood pressure, among other effects. “Many people shy away from reading or fail to see it as a form of self-care,” she writes. The key is to find books, magazines, or other texts that interest you, whatever they may be, and to not be daunted by a particular time commitment. A 2009 study from the University of Sussex demonstrated that reading silently for only six minutes lowered stress levels by up to 68%.
Consider visiting your local library or bookstore and browsing the shelves for a new book this weekend!
Add Some Music to Your Routine
The same University of Sussex study that considered reading’s role in stress-relief found that listening to music lowers stress levels by up to 61%. If your weekend plans include running errands or other household chores, adding music to the mix may help you encounter those responsibilities from a calmer mental state.
Not sure what to listen to? Any music you enjoy can provide a welcome distraction from otherwise monotonous or unpleasant activities! Premade playlists can be helpful resources when you are stuck on a choice or do not have the energy to put together your own list of tunes. You can find these on YouTube, Pandora, Spotify, and other music websites. I’ve included a handful of Spotify’s happy and calm playlists below as options:
Whether you take advantage of the activities listed above this weekend or another time, I hope you find them helpful resources along your mental wellness journey. From all of us at the Consortium, we wish you a happy Friday and a wonderful weekend!