Organized by T B A and David Theodore, Impostor Cities explores the tension of “film-famous” Canadian cities that rarely get to play themselves.
Why are Canada’s buildings so good at role-playing as elsewhere in films? For T B A and David Theodore, the question is at the heart of Impostor Cities, the exhibition selected to represent Canada at the 2020 Venice Biennale of Architecture. Its Montreal-based organizers offer a novel way of thinking about the country’s architectural landscape, challenging established reference points of geography, history and politics, by instead bringing attention to representations of Canadian architecture in (predominantly American) mass culture.
Impostor Cities will be presented by a collaborative team of educators, architects, critics, and designers under the umbrella of T B A + David Theodore. The project will be curated by Theodore, a professor at McGill’s Peter Guo-hua Fu School of Architecture, while architecture and design studio T B A – spearheaded by Thomas Balaban and Jennifer Thorogood – will oversee design and production. Transforming part of the Canada Pavilion into a cinematic experience, the exhibition will invite visitors to interrogate representations of Canadian architecture through an audio-visual experience that the curators describe as “movie mode.”
Confronting visitors with a barrage of supercuts, Impostor Cities aims to induce a state of visceral immersion that draws exhibition-goers into the world of film. Opening with an engrossing green-screen installation, the exhibit will be dominated by studies of Canadian architectural landmarks in cinema. Buildings will be displayed through a rapid collage of cuts from various films, showing individual works of architecture through a multiplicity of lenses. “Looking at cities through movies and TV shows gives a playful new look at Canadian cities, allowing visitors to think about what makes Canadian architecture distinctly Canadian,” says Theodore.
A schematic exhibition diagram
Canadian cities are a well-established Hollywood stand-in for urban locales around the world. Toronto plays New York, Los Angeles, or Tokyo – sometimes sharing credits with Vancouver – while Montreal often takes on continental roles, masquerading as anywhere from London or Paris to Moscow and Milan. “There’s a whole economic and professional infrastructure that supports the trend,” says Theodore, explaining how a combination of subsidies, favourable currency exchange rates, sophisticated studio infrastructure, and a skilled workforce makes Canadian cities uniquely attractive filming destinations for Hollywood productions. The cultural dominance of Hollywood film puts Canadian architecture before a global audience. By the same token, however, it also ensures that the most widespread depictions of Canadian cities come from outside the country.
For Torontonians, it means seeing the Art Deco R.C. Harris Water Treatment Plant reimagined in the cinematic chiaroscuro of a prison or asylum. In Greater Vancouver, the concrete mass of Arthur Erickson’s Simon Fraser University campus becomes a CIA recruitment centre, or the headquarters of any number of vaguely defined – but unfailingly nefarious – corporations. From Halifax Harbour to Winnipeg’s Exchange District and Kingston’s Market Square, Canada’s cityscapes have quietly become part of the American cultural landscape.
A green-screen view of the Canada Pavilion.
According to T B A’s Thomas Balaban, the protean manifestations of Canadian cities in Hollywood cinema evince the country’s architectural qualities. “You have neighbourhoods in Winnipeg that have remained remarkably intact since the 1940s,” Balaban explains, “which is hard to find in the US.” In Toronto, the 20th century urban fabric depicted as 1960s Baltimore in Guillermo del Toro’s “The Shape of Water” similarly calls attention to the quality (even beauty?) of local streetscapes. While we might be tempted to diagnose the “impostor” quality of Canadian cities as a symptom of their blandness, Balaban stresses the evocative power of Canadian architecture. “Filmmakers wouldn’t be drawn to Canadian cities if they didn’t see something there,” he says, framing Impostor Cities as a “celebration of the country’s incredibly diverse architecture.”
It’s a celebration that invites rich questions – and caveats. How do cinematic interpretations of architecture inform our relationship to it? As we move from city to city and coast to coast, will we find anything distinctly “Canadian” about the country’s architecture? And if Canadian cities are perpetually depicted as elsewhere, does that alter their own sense of place? “We’re hoping to find out,” says Theodore.
Alongside T B A + David Theodore, the core team of Impostor Cities also features Sarah Mackenzie and Pawel Karwowski, who will be responsible for communications and the public face of the project. The team will be complemented by a wide range of collaborators, with Alanna Thain and Nick Cabelli coordinating film curation and research, while artist and educator Randolph Jordan will curate the exhibition’s sound. Impostor Cities is also supported by the Canada Council for the Arts. The Council is making a contribution of $500,000 towards the 2020 exhibition and is also acting as Commissioner.