Small Business Owners' Success Criteria, a Values Approach to Personal Differences
Gorgievski, Marjan J., Ascalon, M. Evelina, Stephan, Ute, Journal of Small Business Management
This study of 150 Dutch small business owners, identified through business/network directories, investigated relationships between owners' understanding of success and their personal values. Business owners ranked 10 success criteria. Personal satisfaction, profitability, and satisfied stakeholders ranked highest. Multidimensional scaling techniques revealed two dimensions underlying the rank order of success criteria: person-oriented (personal satisfaction versus business growth) and business-oriented (profitability versus contributing back to society),Furthermore, business growth, profitability, and innovativeness were guided by self-enhancing value orientations (power and achievement). Softer success criteria, such as having satisfied stakeholders and a good work-life balance, were guided by self-transcendent value orientations (benevolence and universalism).
Introduction
The acquisition of wealth, recognition, and growth has been considered the normative criteria by which business owners have been judged to be successful for the past decades (cf. Julien 1998; Littunen 2000; Wang et al. 2004). This has greatly influenced research and theorizing to date, but it remains unclear to what extent these criteria reflect the success criteria that business owners indeed apply to determine whether or not they are successful. Moreover, the underlying motivators for individual differences in evaluations of entrepreneurial success are still largely unknown.
Our objective is to contribute to small business and entrepreneurship research and education by providing a more comprehensive understanding of the way business owners evaluate success and business owners' personal values as its potential predictors. Current research and education emphasizes success criteria relating to technical aspects of management and finances with the goal of maximizing profit and growth (cf. Wilson 2004). However, building on a review of the literature (e.g., Adams and Sykes 2003; Bennett and Dann 2000; Littunen and Tohmo 2003; Paige and Littrell 2002), our study demonstrates that business owners also use other types of criteria to evaluate their success, for example, societal impact and personal satisfaction. The achievement and acceptance of such criteria are neither sufficiently researched nor instructed by entrepreneurship educators (Wilson 2004). This leaves a wide gap in the area of small business and entrepreneurship. A better understanding of the subjective success criteria that business owners use is important because owners who fail to fulfill their personal goals are more likely to close their businesses, even when those are profitable (e.g., Bates 2005). Understanding personal values as drivers behind business owners' choice of success criteria is equally important because it has inherent importance on the health, well-being, and financial success of business owners. Living in accordance to ones' values predicts long-term personal well-being and satisfaction, whereas a misfit between a person's values and choices leads to internal conflicts and distress in the long term (Bardi and Schwartz 2003). In turn, distress has been found to impair business owners' financial performance (e.g., Gorgievski-Duijvesteijn et al. 2010; Gorgievski-Duijvesteijn, Giesen, and Bakker, 2000).
Thus, the alignment of one's values with one's ideas of success has multiple benefits. Insight into business owners' objective and subjective success criteria and the way they align with one's values can be used to develop more valid methods to advise business owners on how to attain and sustain satisfying careers. First, individuals embarking on an entrepreneurial path can be guided toward a specific direction based on their values. Second, existing business owners can be taught to align their values and success criteria to achieve greater well-being.
This study has been carried out among Dutch small business owners. Dutch business owners are a good sample for studying the relationship between intrinsic motivational aspects and business goals. …