One of the more recent discoveries of neuroscience is that when you stare into space, gather wool, daydream, or otherwise let your mind wander, the “default-mode network” of your brain starts to rev up into high gear. This network has quite naturally captured the fancy of meditation researchers: meditation is a practice of being mindfully present, with little if any mind wandering. So if meditators succeed in suppressing mind wandering, what does that mean they have done to the default network? Is it just that they are focused on the present, and so do not slide into the default pattern as often – but when their minds do wander, it’s the same kind of pattern? Or does the meditator enter a different default state entirely?
The activity your brain defaults to when you don’t direct it is quite extensive. From Buckner et al. (2012).
The first place to look for differences in neurological activity is during meditation itself, when you can be most confident that meditators will be doing something different than non-meditators thanks to their years of practice. And in this study, we do mean years; the dozen meditators all had at least 10 years of practice at meditation, while the dozen non-meditators were selected to match each meditator on demographic factors (age, sex, race, and so on) while having no meditation experience at all. Everyone was asked to practice three different kinds of meditation (focused meditation on the breath, loving-kindness meditation, and a broader awareness that was just supposed to follow thoughts where they would go) while in a brain scanner.
As you might expect, the seasoned meditators were much better at maintaining their focus, reporting one third to one half the mind-wandering that meditation novices did. At the same time, meditators showed less activity in two key regions of the default network: the posterior cingulate cortex (PCC), a central hub of the default network whose precise role is still something of mystery, and the medial prefrontal cortex (mPFC), another hub that has been linked to self-awareness and perspective taking. Even when novices were trying to meditate, activity in these regions was fairly high, suggesting some mind-wandering and reversion to the default network. The experienced meditators, though, had far less activity in these regions, suggesting that their meditation was on-task, just as they reported. Sadly, there were no correlations run to see if activity in these regions directly corresponded to self-reports of mind-wandering, so we have no direct evidence that the changes in the brain correspond to changes in thought, but we do have some nice hints.
Even more intriguing was what happened in the 2 minutes of resting state before the meditation periods began. Everyone had been told just to close their eyes and not think of anything in particular, but virtually the same pattern of activity was found: non-meditators engaged the default network, but meditators did not, or did so to a much lesser extent. As the authors of the paper poetically put it, “meditation practice may transform the resting-state experience into one that resembles a meditative state” (p. 20255). If you’re attracted to the notion of that meditative state, of course, the possibility that it could become your default mode must be almost intoxicating.
The reason that these differences in the default network might persist even when we are not meditating is that the transient changes in activity levels while we are meditating might – slowly, gradually, over time – alter the way the different brain regions of the default network talk to each other. Some connections will strengthen, others will weaken, until the default network is shaped to focus on the present instead of letting the mind wander. The PCC emerges again as a key player, because it was more strongly connected to regions important for self-control (the anterior cingulate cortex and the dorsolateral PFC, near neighbors of the default network). Without a clearer notion of exactly what the PCC does it’s hard to say what these stronger connections mean, but one possibility is that when the brain shifts into its default mode, the PCC uses these strong connections to help initiate some cognitive control and maintain a focus on the present.
It’s much more difficult than just flipping a few switches, but your brain’s default setting can actually be changed. Now, we just have to get a better grasp on how, and what those changes mean for everyday life.-9 PMID: 22114193
