HealthTalk: Trans fat
The Centers for Disease Control report that, in 2006, 16 million adults in the United States were diagnosed with some form of heart disease. Although heart disease is a major problem in this country, it can be prevented by simple changes in one’s eating habits and general lifestyle. One such lifestyle change that is rapidly gaining popularity is avoiding foods containing large amounts of trans fats.
According to the Mayo Clinic, foods such as margarine, crackers, some types of cookies, and shortenings contain substances called trans fats, which significantly increase the risk of heart disease. Trans fats are produced by hydrogenating other oils. In this process, hydrogen is added to liquid oils, converting them into solid fatty substances. In general, trans fats act as a preservative and enhance the flavor of food. According to the Food and Drug Administration’s (FDA) website, starting January 2006, all nutrient labels were required to state the quantity of trans fats in the food product. The FDA’s reasoning behind this move was that consumers would now be able to pick and choose their foods carefully and avoid foods with large amounts of trans fats.
The most important factor that makes trans fats so unhealthy is that they increase the body’s levels of low-density lipoprotein (LDL) and decrease levels of high-density lipoprotein (HDL). Both LDL and HDL are carriers of cholesterol, but while high HDL levels can be healthy, high LDL levels increase the chances of heart disease.
Cholesterol is a fatty substance found in the body that has a number of uses — it is an integral component of the cell membrane and a precursor for making vitamin D and some hormones. However, despite of its beneficial properties, excess cholesterol in the bloodstream can be harmful. It is often deposited on the walls of blood vessels, making them narrow and brittle. This causes a condition known as atherosclerosis. It is difficult for blood to pass through such narrow vessels, and as a result, organs of the body might receive less blood and less oxygen, leading to a variety of problems. The clogging of the coronary arteries in this way can lead to a heart attack.
As explained on, cholesterol is not soluble in the blood and has to be transported across the bloodstream through specialized packages called lipoproteins. As described earlier, the lipoproteins can be of two types: LDL and HDL. While LDL tends to carry cholesterol throughout the bloodstream to different parts of the body, HDL carries excess cholesterol to the liver, from where it can be properly passed out of the body. Thus, high LDL levels indicate a large amount of cholesterol in the bloodstream that causes plaques and atherosclerosis. By increasing LDL levels in the body, trans fats increase the chances of artherosclerosis and, eventually, heart disease. Although the major side effect of trans fats is the increase in LDL levels, trans fats also have a number of other side effects. For example, trans fats can also increase the amount of triglycerides, another type of fat that can contribute to atherosclerosis. According to the Mayo Clinic, trans fats may also damage the layer of cells that line the blood vessels, causing inflammation. Such inflammation can also play a role in the hardening and narrowing of blood vessels.
Since knowledge regarding the ill effects of trans fats has increased, fewer foods contain large amounts of trans fats. The FDA’s 2006 policies that require trans fats to be listed in nutrient labels have also helped increase awareness regarding the kinds of foods that still have trans fats. Along with avoiding foods that contain trans fats, people should also avoid foods with large amounts of saturated fats, such as coconut oil and palm oil. Like trans fats, saturated oils increase the LDL levels in the body. In addition to decreasing the consumption of trans fats, consumers are encouraged to replace oils high in saturated and trans fats with healthier oils, like olive and canola oils.