By Thomas A. Wake, Ph.D., STRI Research Associate
Since 2002 the Proyect Arqueológico Sitio Drago, co-directed by Thomas A. Wake and Tomas E. Mendizabal, has produced findings that have changed the interpretation of past populations living on Isla Colón and in the Bocas del Toro Archipelago. It is clear now that Isla Colón was settled approximately 2,000 years ago, a thousand years earlier than previously thought. Evidence of continuous contact with the highlands on the mainland to the south over the past 2,000 years suggests that the region was also less isolated than originally assumed. The material culture recovered from Sitio Drago illustrates contact with a variety of culture areas covering much of lower Central America, including Gran Coclé to the east, Gran Chiriquí (Pacific) to the south, and Gran Nicoya to the northwest.
The people living at Sitio Drago had a level of social organization that allowed them to actively interact with other local and regional populations. For example, there are no sources of tool stone on Isla Colón, yet boulder mortars, rocker-manos and basaltic stone axes and projectile points are not uncommon on the island. The past inhabitants of Isla Colón repeatedly organized the requisite number (50-100, if not more) of people and watercraft necessary to transport large boulders from the mainland to island hilltops. In addition to the regionally diagnostic trade ceramics, the stone and shell artifacts recovered from Sitio Drago are evocative of an active exchange network operating between Isla Colón and different parts of the mainland, up to 400 km away. Isla Colón and Bocas del Toro were part of a larger lower Central American trade and exchange network from at least 2,000 to 500 years ago.
Data recovered from survey, surface collection, and limited excavation suggest that the situation changed radically in the sixteenth century CE, soon after Columbus’s October 5, 1502, visit to Bocas del Toro. Material culture recovered from postcontact sites on Isla Colón appears less technologically sophisticated and more insular. These sites are located on interior hilltops and caves, away from the coast and hidden from view. Few exotic ceramics are found, and those recovered appear less diverse and more crudely made compared to those from a century earlier.
All indications suggest an early historic period collapse of the earlier far-flung network, resulting in a more isolated local population. This situation began to change in the eighteenth and nineteenth centuries CE with the influx of pirates, Anglophone Afro-Caribbeans, different Indian groups, and banana plantations, ultimately producing the diverse community that is modern Bocas del Toro.
The nearly 20 years of field work in Bocas del Toro, Panama have been tough at times but richly rewarding. Research collaborations developed with STRI and UTP Faculty (Richard Cooke, Ashley Sharpe and Aaron O’Dea, to name a few, and Alexis Mojica) have blossomed and are bearing academic fruit in terms of new knowledge and interested students. The Proyecto Arqueológico Sitio Drago has served to educate North American university and Panamanian students about the vibrant culture of Bocas del Toro and Panama in general. Many participants have remarked on how enjoyable and eye-opening their experience in Panama turned out to be. Panamanian participants in the project have honed their professional skills and continued their careers in archaeology. Several project participants have returned to conduct further research into the archaeology of Bocas del Toro. So far, the project has produced several publications, 3 master’s theses, 1 dissertation and another one on the way. We look forward to many more years of enjoyable fieldwork and research collaboration in Panama.
References
Wake, Thomas A. (No Date). A Pre-European Archaeology of Greater Bocas del Toro, Western Caribbean. In El Mar Caribe: The American Mediterranean, edited by C. Dennett and V. Lyall, Pp. xx-xx. Frederick & Jan Mayer Center for Pre-Columbian and Spanish Colonial Art, Denver Art Museum.
Wake, Thomas A. 2014. Ten years in the tropics: Archaeological research and education in Bocas del Toro, Panama. Backdirt: Annual Review of the Cotsen Institute of Archaeology at UCLA:82–93.
O’Dea, Aaron, Marian Lynne Shaffer, Douglas R. Doughty, Thomas A. Wake, and Felix A. Rodriguez. 2014. Evidence of size-selective evolution in the fighting conch from prehistoric subsistence harvesting. Proceedings of the Royal Society of London B: Biological Sciences 281(1782):20140159.
Wake, Thomas A., Douglas R. Doughty, and Michael Kay. 2013. Archaeological investigations provide Late Holocene baseline ecological data for Bocas del Toro, Panama. Bulletin of Marine Science 89(4):1015–1035.
Wake, Thomas A., Alexis O. Mojica, Michael H. Davis, Christina J. Campbell, and Tomás Mendizábal. 2012. Electrical resistivity surveying and pseudo-three-dimensional tomographic imaging at Sitio Drago, Bocas del Toro, Panama. Archaeological Prospection 19:49–58.
Wake, Thomas A. 2006. Prehistoric Exploitation of the Swamp Palm (Raphia taedigera:Arecacae) at Sitio Drago, Isla Colón, Bocas del Toro, Panamá. The Caribbean Journal of Science 42(1):11-19.
Wake, Thomas A., Jason de Leon, and Carlos Fitzgerald Bernal. 2004. Prehistoric Sitio Drago, Bocas del Toro, Panama. Antiquity 78(300).