The Internet of Things (IoT) wave will soon wash over Australia’s small to medium enterprises.
The Internet of Things, or IoT, is basically the idea of making non-connected devices in our environment connected to us, or each other. For two generations we’ve worked with computers using screens and keyboards, but the future where it involves IoT leaves that paradigm. Smart and connected devices don’t require screens to talk to us, or to each other.
In the early days of computing, people like Bill Gates, Paul Allen, Steve Jobs and Steve Wozniak were “makers”, using technologies the Altair 8800 to make computing software, and CPUs like the Intel 8080 to make computer-enabled electronics.
After two to three decades of “doing” using mass-produced and general-purpose hardware and software, “making” is happening again with low-cost access to the Internet, WiFi, and computing with ready-made micro-computers such as the Raspberry Pi, C.H.I.P, Intel Edison, and the cloudBit.
With less than $100, you or I can add connected computing technology to something that was previously unconnected, like a doorbell.
Depending on where you position yourself and your business, that could be a wave of opportunity, a wave of data, a wave of disruption or a wave of security breaches.
Along with Artificial Intelligence (AI) and nanotechnology, IoT threatens to shake up our world much like the Internet did between 1996 and 2009, where new jobs were born, many made redundant, and start-ups like Facebook, Google and Twitter emerged from dorm rooms and basements into world mega-companies.
As a distant projection we can imagine nanobots who “live” in your clothes that can repair your wear and tear, change the colour of the cloth and even modify your clothes according to the data of your scales/health monitors. As with anything in our world however, cost is the main driver and in the SME world it will be the small things that make a big difference that will change first.
An example of a likely use in SMEs would be fleet cars/trucks. Already available through Satellite tech, we may soon see the technology become cheaper using the Internet and having our cars join the Internet of Things. Or perhaps the fuel tanks of our fleet cars, or their safety cams.
At this point, as a SME owner I could learn a lot about how my company cars are being used, where they are going and get indicators of how long they will last or how regularly they need to be serviced. As a tool manufacturer, my plant equipment can inform me when a part is about to fail or requires service. As a café owner, my storage tubs could report when a threshold of bacteria has been reached, requiring food to be tossed out ahead of schedule.
IoT will start where it’s cheap to implement and provides maximum benefit, and gradually backfill through our world to where it becomes ubiquitous. If it hasn’t already struck you, the security implications are monstrous.
It would be nice to have my PC hard drive IoT enabled, to report to me or my backup software that it predicts a failure in itself. Of course, an IoT hard drive is connected to the Internet, putting all of my data at risk. What would be at risk if my insurance company, my government, other governments, criminal gangs or my former partners could access everything on my hard drive?
Thankfully those behind IoT are thinking ahead, and trying to create IoT “things” that have “baked-in” security, national or international standards of a sliding scale so people can make informed decisions without an in-depth technical knowledge of IT and IoT security.
The other mind-bending change coming from IoT is data. The amount of data we’re likely to produce in the next two decades will be exponentially more than in previous history. Big Data is going to get really big now, as millions, then billions of “things” around the world begin to report to millions of databases.
So where does Diamond fit into all of this?
The closest thing we sell to IoT right now is smart phones. Our iPhones and Android phones are early examples of IoT, although true IoT of the future will be mostly without a display or human interface. One key area of security relating to IoT is already valid.
The big change coming that relates to Diamond is the security of outgoing data. One of the main advantages of modern Unified Threat Management devices (UTM) is that they are capable of monitoring where traffic is going, where it came from and what’s in the data. In the past much of the data from SMEs has been coming in, but IoT will further increase the traffic going out, and it will need to be protected, restricted and monitored.
A UTM is already useful for monitoring people, applications and potential threats from PCs and servers and smart phones, and will become a necessity going forward as IoT becomes commonplace.
We have a fascinating future ahead of us with these emerging techs, perhaps the biggest explosion of knowledge the world is yet to see. The security and privacy challenges ahead of us are huge, but we humans will adapt and learn as we always have and see some mind-boggling changes in our lifetime..