As a physical therapist, I have the opportunity to work with individuals who suffer with chronic disease, cardiovascular conditions, neurological disorders, and of course, my specialty: musculoskeletal and orthopaedic conditions. A person’s rehabilitation process can be highly variable even within those who are recovering from the same type of injury. While most of my post rehabilitation clients have been able to move forward and live successful lives, there are other clients who took significantly longer to heal. Unfortunately, there are some who were never able to recover to any significant degree.
The reasons why a person may not recover are vast and complicated. However, I have identified six categories of common reasons why a person will not fully heal and recover or take an extended time.
6 Categories of Common Reasons Why You Won’t Heal:
- You’re getting the wrong treatment for your condition.
- The injury or condition isn’t capable of healing.
- Physiological and social conditions are affecting your healing.
- Poor nutrition.
- Poor sleep quality.
- The risk factors and causative factors that led to the disease and injury are still present and affecting the current condition.
In Part 1, treatment for the condition is addressed. In subsequent posts, I will cover the other categories in addition to providing you with methods and strategies for recovery to insure that you will heal and recover and/or effectively be able to manage your injury or medical condition.
You’re Getting the Wrong Treatment for Your Condition:
Sadly in today’s health care environment, it’s not uncommon for individuals to get the wrong treatment for his/her condition and/or inappropriate care which can affect the recovery process. As a physical therapist, I continue to see countless examples of individuals getting wrong and/or ineffective treatments to manage a particular injury or medical condition.
Sometimes this is deliberate as part of some newest and greatest product scam that is touted as curing this or that condition, but most of the time, it’s done inadvertently. This problem isn’t just in one medical profession. It’s throughout the entire healthcare system.
The following three examples illustrate what happened to some of my prior physical therapy clients. Unfortunately, this list could be very long if I included every example I have witnessed.
Example 1: Total Hip Replacement
The client presents with apparent hip and leg pain. The client has undergone a total hip replacement in an effort to eliminate the pain only to have it still be present. Upon further examination, the cause of the hip and leg pain was an undiagnosed lumbar spine injury. Once the lumbar injury was managed appropriately, the pain in the hip and leg resolved. Although the client had arthritis and deterioration in the hip to justify the hip replacement, it wasn’t the real cause of the pain. In this case, the client never needed the hip replacement in the first place.
Example 2: Low Back Pain
The client complains of ongoing low back pain (LBP). Although there are many reasons why one may experience LBP, the pain is of mechanical origin in the majority of cases. This means that something in the musculoskeletal system is the pain generator. The client should be able to establish movement patterns that can help to determine if the pain is improving or worsening. This directional preference helps me as a physical therapist to guide treatment decisions.
Extending the spine makes the pain improve, but the client’s previous physical therapist has him performing primarily flexion (bending forward) exercises as part of the rehabilitation protocol. This treatment is not only ineffective, but it significantly slows the healing response as the client continued to aggravate the injury by moving repeatedly in the wrong direction. Upon stopping the flexion based exercises, the client’s LBP improved and fairly quickly went away.
Example 3: Chronic Headaches
The client sees a neurologist for assistance managing what appears to be a case of chronic migraine headaches. The client is given prescription medications which are taken on a regular basis in order to help manage the migraines. Although the medication helps to reduce the length of time of suffering, the client continues to experience migraines on a regular basis. The treatment may not be wrong, but it certainly isn’t overly effective. Worse yet, there is the potential for multiple side effects from taking the medication.
In this particular case, the client had a cervical alignment issue which caused mechanical neck pain that would trigger a migraine. Together, we were able to correct the alignment issue, and more importantly, fix the chronic poor sitting posture that lead to the alignment issue. This eliminated the headaches completely and the need for the migraine medication.
I tell these stories from past clients to illustrate the point that wrong and/or ineffective treatments can lead to a significantly longer than necessary recovery time. These clients were fortunate because the true cause for the pain was identified and recovery occurred.
There are a countless number of people who continue to suffer with an incorrect or ineffective treatment therapies. The key to successfully rehabilitating and recovering from a condition is to direct the right treatment plan for the condition. This includes how the actual injury or condition is being handled as well as addressing other risk factors or precipitating factors that directly affect the condition.
How to Identify an Incorrect or Ineffective Treatment Therapy:
- You aren’t experiencing any relief in pain or symptoms from the treatment.
- Your symptoms continue to worsen.
- You have been using the same treatment for weeks or months without resolution. In the case of chronic disease, management of the condition hasn’t been effective.
- The treatment and why it’s effective cannot be logically explained.
- You haven’t been given any tools or education on how you to help improve or manage the condition, the rehabilitation or disease process, and its symptoms.
- You are told that there are no other options.
If you are unsure whether or not the treatment you are receiving for your condition is helping, then it’s up to you to be proactive and seek a second opinion. Although you should be cautious in researching for medical information online, there are reputable websites that can help to educate you about symptoms and possible causes for your condition.
If you suspect that your treatment course is incorrect, discuss your concerns with your medical provider. Don’t be afraid to seek a second (or even third opinion) if necessary. There are many options, and help is available. Don’t give up!
Have you experienced an incorrect treatment or ineffective medical treatment before? What did you do in order to resolve it?!