Care homes must have their house in order, now that the new General Data Protection Regulation (GDPR) has come into effect. Introduced two years ago, the GDPR is now an enforceable law. It aims to increase the data privacy rights of individuals while increasing the responsibilities of organisations in the way they collect, store and process personal data.
Failure to comply with the GDPR could spell disaster for care homes, who handle a lot of personal and sensitive data. They risk enforcement action and hefty fines from the ICO, being sued by individuals in case of a data breach and damage to their reputation from the negative publicity.
The GDPR increases care homes’ liability for personal data, such as people’s email addresses or phone numbers, sensitive data such as NHS numbers and medical records, and special category personal data such as ethnicity or religion.
It is particularly challenging for the care business, as so many individuals in care settings have multiple care-givers, changing degrees of ability to give or rescind consent.
And GDPR relates not only to residents, but to their next-of-kin and associates, care home employees, health and social care staff and consultants, volunteers, plus third-party suppliers such as catering and cleaning, for example. Basically, every piece of personally identifiable data you handle! If you need more information about training your staff please click here.
Under the GDPR, accountability and record-keeping is key. All data-related documentation such as privacy policies, data protection policies, terms and conditions, data maps, privacy impact assessments, data breach notifications and security policies will need to be reviewed.
For GDPR compliance, care homes will need to have assigned a lawful purpose for processing data before they actually do it. This is fairly straightforward if the processing is required to meet contractual obligations or for financial purposes. However, it’s more challenging when consent is required for processing.
Rules for consent are extremely tight under GDPR, so care home staff must be trained to make sure they understand their roles and responsibilities. Care homes will need to review their privacy policy – sometimes called a privacy notice – so that people who consent to your data use are clear on exactly how you’re going to use it.
And, significantly, under the GDPR, just because someone has consented to receiving key documentation on their loved ones by email, doesn’t mean you can send them your latest newsletter, brochure or promotion without them actively requesting that you contact them again. Under the GDPR care homes can only collect data for specified and limited purposes. It will have to be relevant and limited only to what is necessary. It must be accurate and kept up-to-date.
Care homes are also responsible for making sure that they have the latest technology and security that will keep safe the personal data they handle. So, care home managers will need to review IT, marketing, HR and customer service systems and technologies; to make sure they can retain, process, report and secure at a level compliant with the GDPR. This will also involve reviewing encryption, anti-virus software, data backup, recovery and business continuity plans.
As data controllers, care homes are still responsible for making sure any third-party suppliers are GDPR compliant. So contracts, terms and agreements etc. will need to be reviewed to reflect this.
Subject access requests (SARs) – where care providers and residents alike can ask to see what information the care home holds on them – are free and faster under the GDPR. There’s no longer a £10 charge and care homes will have only 30 days to comply. This could instigate an increase in SARs, so care providers are advised to prepare for this.
Individuals can also request to amend and in some cases delete their personal data. They may also ask for their data to be made portable in a recognised electronic format so they can move it to another care home, for example. Staff training is important, so they are aware of the process to follow when dealing with or escalating SARs within the business.
In case of a data breach, care providers must know how to respond. If it’s deemed likely that personal data has been exposed, the care home must inform the ICO within 72 hours. If it’s a serious data breach, they will also need to inform the individuals whose personal data is involved.
Do you need help training your care providers? Me Learning was founded with a focus on health and social care, and we understand how to ease the burden of legislation. We’ve also been able to reduce costs and provide flexible GDPR training for both private and public care providers who work with both adults and children.
To find out more about our online GDPR courses endorsed by specialist data privacy lawyers Clayden Law click here.
Do you have a question?
Whether it’s a technical question or a sales enquiry, our helpdesk and sales teams will be happy to help.
