The figure below shows a typical KildClient session:
The first thing to note is that, just like in other MUD clients, there is an area where the output of the MUD is shown, and a text box below where you can enter commands. You can edit the commands before being sent, and only after you press ENTER the line will be sent to the MUD.
The box that shows the output of the MUD keeps by default the last 2000 lines received (but this number can be changed, see Section 4.7). You can recall the previous lines with the scrollbar or with the page up and page down keys.
A feature not so universal is the support for opening several Worlds simultaneously, and using tabs to alternate between them. You just need to click the tab to change to that World. If the name is displayed in red, that means that there is new text in that MUD, text you haven't seen yet. If the KildClient windows does not have focus (that is, when you using another window and leave KildClient in the background) and new text arrives in any World, the title of the KildClient window will change to "(*) KildClient" to alert you of that.
There are other ways to move to another open World. The keyboard shortcuts CTRL+Page up and CTRL+Page down move to the next or previous World, respectively. Alternatively, you can use ALT+Right arrow o ALT+Left arrow instead to achieve the same effect. To got directly to a World, press ALT+num, where num is a number from 1 to 9. This way you can move to any one of the first nine open Worlds.
On the left of the command entry box there is a button with a broom. Click on it to erase the whole command line.
You can recall recently typed commands with the arrow keys. Pressing the up arrow recalls the previous command, and the down arrow moves to the following command. If the input box has multiple lines, as described below, then use Alt and the arrows.
On the right, there is a button with an arrow poiting downwards. Click on it to get a list of the last typed commands. Selecting one of these commands will put it in the text box for you to repeat it, possibly changing it before.
On the extreme right, there are two small arrows. These arrows allow you to enlarge the input box if you type long input lines. The input box can have from one to ten lines. The arrow pointing up increases the size, the arrow pointing down decreases it.
The behaviour of input boxes with one or several lines is different: if there is only one line, and more text than fits the width is entered, the text is scrolled horizontally. On multi-line input boxes, however, text that does not fit one line is wrapped to the next line. A scroll-bar may be displayed if the whole text does not fit in the number of lines selected.
As mentioned briefly before, the behaviour of the up and down arrows is different. If the Alt key is held, then you will retrieve other commands in the history. If you press just the up and down arrows, it may retrieve another command or simply move the cursor: if you have just sent a command or just retrieved a command, then the arrow keys will move through other commands, but if you have moved the cursor in order to edit, the up and down arrows will move to the previous or next line. This may sound complicated, but is actually natural, the arrows do what you expect them to do.
In the single-line input box (but not in the multi-line one), a feature called command auto-completion is enabled: when you start typing a command, a list of the previously typed commands that start with the same string you've typed. You can select one of them from the list to repeat it or change it.
However, in both input methods, you can type the start of a command and press Alt+Shift+Up arrow to retrieve a previous command that starts with the typed text. You can then use Alt+Shift+Up arrow and Alt+Shift+Down arrow to navigate through all the saved commands with that prefix.
You can enter several commands at once in the command line separating them with %;. For example, if you type unlock door %; open door, two commands will be sent to the MUD in sequence: first unlock door, and then open door. Spaces around the %; are ignore and can be used for clarity. Note: it is possible to configure the command separator to be another string instead of %;. See Section 4.3.
Another special feature of the command line is that you can execute Perl statements from it. Starting a line with a slash (/) causes that line not to be sent to the world, but to be intepreted by the built-in Perl interpreter. To try it, type in the command box /$world->echonl("Hello, Perl World!"). You should see "Hello, Perl World!" printed in the screen. What has happened is that the command $world->echonl("Hello, Perl World!") has been run by Perl, and this command causes a string to be printed in the screen (but not to be sent to the MUD). Don't worry if you do not understand the syntax yet, we will explain it in Chapter 7. For now, just keep in mind that if you type a line starting with /, it will not be sent to the MUD, but what follows the slash is treated as a Perl command and executed.
Should you need to send a line that starts with / to the MUD, use two slashes: entering //list will send /list to the MUD.
If you are using the multi-line input bar, you can enable to built in spell checker to verify the text as you type. Misspelled words will be highlighted with a red line below them, and you can right-click on them to show a menu with possible spellings. To configure this feature, see Section 4.3.