Renewable Energy and Health: Me, Myself and I
In the continuing debate surrounding how, why, when, where and whether we should move decisively ahead with renewable energy sources, there are just as many reasons raised for opposing wind, solar, biomass, geothermal, biogas and others as there are for supporting them. There is one area, however, that gets swamped under the economic, environmental and political pros and cons of renewable energy in the public debate: Human health. Yet, despite the relative lack of public attention, I find it nearly impossible to build a case against renewables in this regard. If any human being seriously, selfishly and rationally considered what’s in his or her best long-term health interests, renewable energy would be a no-brainer.
Let’s consider the three traditional energy sources we use today: Coal, oil and natural gas. When extracted, processed and burned, each of these fossil fuels releases nasty chemicals into our air, water and soil. Oil and natural gas production facilities produce a long list of hazardous air pollutants and volatile organic compounds that can cause irritation of the skin, eyes and upper respiratory tract, dizziness, vomiting, blood disorders, nervous system defects, birth defects, cancer and more. Burning coal in power plants emits a similarly long list of hazardous pollutants into the air, including mercury, arsenic and lead, that can also cause irritation of the skin, eyes, nose, throat and breathing passages, neurological disorders, kidney and liver damage, birth defects, and cancer to name a few. Extracting coal through mountaintop removal and obtaining shale gas through fracking methods have significant real and potential impacts on lakes, rivers and aquifers on which many communities rely for safe drinking water sources. Both offshore oil extraction and onshore oil transport have similarly significant real and potential impacts on the water and soil resources that we rely on for fishing and agricultural food supplies. The list goes on.
Now let’s look at two main renewable energy sources that don’t require burning things: Wind and solar. Almost no negative health impacts occur to humans throughout the assembly, construction and power generation processes for these two renewable energy sources. No exposure to air emissions that contain mercury, arsenic and lead. No risk of contaminating drinking water with sulfates, benzene and other synthetic chemicals. No risk to our agricultural water supply, of exposing livestock to nasty chemicals, or crashing fish populations off the Alaskan and Gulf coasts.
However, I used the word “almost” above because I want to paint the whole picture here. The Minnesota Department of Health recently released a comprehensive report on the public health impacts of wind turbines. These impacts revolved largely around low-frequency noise and shadow flicker, with symptoms consisting of “annoyance” and “disturbance” that can be remedied by effective turbine siting and improved turbine technologies. Similarly, the Oregon Department of Transportation put together a concise and well-researched report on the health and safety concerns of photovoltaic solar panels. Although there are some hazardous materials involved in the manufacturing and assembly of an operable solar panel, these are considered occupational hazards that can be contained at the manufacturing site (i.e., not emitted into our air, water and soil), mitigated by automation in the manufacturing process, and can even be recycled back into assembly to avoid exposure to the external environment.
The differing human health impacts between burning fossil fuels and utilizing renewable energy are astounding. If we reframe the renewable energy debate to focus on what humans do best (which is to consider our own survival and well-being over that of the millions of other species on the planet, and even above the well-being of the planet itself), who can argue against renewables? We can and do argue continually about the environmental impacts of continuing to extract, refine and burn fossil fuels. Experts and politicians trade punches over the legitimacy of climate change and the impacts of releasing billions of tons of carbon dioxide into the atmosphere. Average citizens weigh the impact of a short-term increase in electricity costs from implementing renewable energies against the long-term cost stability of ditching fossil fuels. But when the debate turns to human health, there is no reasonable argument against renewable energy.
Maybe I’m barking up the wrong tree here. Economists have long known that people often don’t act rationally or take into account their long-term interests when making decisions. After all, people work, smoke, drink, medicate and eat themselves to death everyday. But if we’re going to make progress towards more sustainable and healthy means of producing energy, we need look no further then ourselves.
Dean says:
February 14, 2012 at 12:25 pm
Some countries in Europe have invested heavily in renewables for a very long time. Their experience can be instructive and shouldn’t be ignored. An example is this report from Spain about the real cost of renewables:
It’s foolish to think the American renewable programs will produce different results. Renewable programs shouldn’t be promoted as the answer to unemployment or a cheaper source of power.
Alan Muller says:
February 17, 2012 at 7:33 am
Your comments on wind and solar PV make sense, but “renewable energy” also includes, as you note but don’t discuss, very highly-polluting and unhealthy sources such as “biomass.” Lumping these together, then exploring only the “clean” ones, is a disservice to the reader.