Four years ago, traded life policy (TLP) funds were labelled as potential replacements for with-profit funds. Three years ago, certain fund providers were pushing for their own IMA sector.
Last week these same fund providers stated that TLP funds were never intended for the retail fund-buying community after the FSA labelled them “high risk, toxic products that are generally unsuitable for the majority of UK investors”.
When a fund makes its return by estimating the date of someone’s death, marketing is always going to be tricky. This task was made no easier when, in August 2006, the American viatical marketmaker Mutual Benefits Corporation (MBC) was prosecuted for fraud. It was found guilty of understating the life expectations of policyholders, which therefore increased the value of their policies.
Despite this, in the years afterwards several funds have been launched to British investors, with the promise of returns uncorrelated to those of equities or bonds. Indeed, back in 2007 a report issued by Professor Merlin Stone of the Bristol Business School, said TLPs might be the best alternative to with-profit funds. For this to happen however, the report said more needed to be done to raise the profile of TLP funds among IFAs. (Comment continues below)
A year later, some TLP product providers said they wanted to lobby the IMA to create a new sector to help promote the asset class. This never happened, given their offshore domiciles and lack of Ucits III status, but the thinking was that a peer group would help promote the asset class, with retail investors in mind.
Odd, then, that these same providers are now at pains to point out that the funds were only ever aimed at “sophisticated investors” (see news analysis, page 12).
Owing to liquidity constraints, TLP funds have never been able to be packaged as Ucits III funds, and last week’s FSA statement will likely be the death knell to any groups looking to change this.
The key problem has always been what happens if a fund runs out of cash and cannot continue paying the life assurance premiums. If this happens, the policies effectively become worthless.
Most of the groups, to give them their due, have always stated that an education drive has been needed to increase demand, but is this drive alone enough to transform so-called retail investors into sophisticated investors?
Just last month, Managing Partners told Fund Strategy it deals with retail investors as long as they are sufficiently sophisticated. However, it added that it is down to the IFA to categorise who is sophisticated and who is not.
SL Investment Management, which has long maintained TLP funds are not suitable for retail investors, puts IFAs in the same category because they rely on the people selling the product for information.
There are far more problems with this investment than understated life expectancy and companies running out of funds to pay premiums. In the US there are hundreds of lawsuits filed to void policies issued to seniors who fraudulently acquired insurance. In some cases courts allowed insurers to cancel the policies and keep the premiums.
Some of these fraud cases insured a retired bus driver for millions; people living in low cost housing whose income is limited to government benefits; a man who filed for bankruptcy two years earlier with a net worth of minus.
So-called sophisticated investors are not as sophisticated as they would like to think of themselves. They do not know half of what they need to know.
Would you invest with a principal whose previous company, doing the same exact thing, went belly-up and was cited in court for selling fraudulent policies to investors. Too many of these con artists recycle themselves, new company name, new state, new investors, new funds, same-old fraud.
Ms Wolk’s comments are quite pertinent in understanding some of the problems with running a TLP fund. There is too much unknown.
In theory the process should be relatively straightforward in that the statistics are reasonably well founded, so the capital and cash flow requirements are quantifiable, allowing sufficient prudent margin for changes in life expectancy. Whilst this may not make for a mainstream investment, it should not require a “sophisticated” investment label.
What is making these funds so high risk is incompetent management and a heavy level of fraud. Since we have been aware of these two elements for quite some time now (the Shepherds Fund collapsed in 2005) it is amazing that the FSA have been so slow to raise questions. Competent management and fraud should be a high priority on their regulatory agenda. It is clear from other scandals that they do not have the tools or the understanding to do such a job.
Rebranding these policies as “Sophisticated” is real head in the sand stuff. Whilst wealthy people may be able to withstand such scandals better than the less wealthy it is no more palatable. And when the losses are predominantly based on fraud and incompetence, and not market conditions, then there is no justification for exposing the wealthy to such risk.
Until this basis of this market it cleaned up it should be banned. It is totally impractical to assume that advisers can do the background work to ensure that funds are being properly run; there has to be a certain level of trust for the market to run at a reasonable cost level.
If the FSA are out of their depth then that I would strongly recommend that advisers stop using these funds until either the providers can demonstrate explicitly a satisfactory level of prudent management, or, as a group, provide a copper bottomed level of guarantee on future behaviour and returns. This may be hard on the reputable providers, but the never ending loses have been a darn sight harder on the purses of honest investors.