On the campaign trail, now-Seattle Mayor Ed Murray hearkened back to the days when neighborhoods played a strong role in city planning. Less than a month before the election, he told a meeting of the Seattle Neighborhood Coalition, “I want to empower the neighborhoods in a way they haven’t been since before (former Mayor) Greg Nickels.”
Murray promised a neighborhood summit within 100 days of taking office. Saturday he will deliver on that promise.
But plans for the half-day summit have left many neighborhood activists labeling the session “Neighborhoods 101” and saying it will avoid discussion of the issues making them most cranky — growth, development and what they say is the city’s lack of responsiveness to their concerns.
The agenda calls for a talk on the civic health of the city and another on the District Council system. The summit is open to the public and will offer tables staffed by 20 city departments, including the library and the animal shelter. Murray is scheduled to give a five-minute welcome, but says he’ll stay for the final 30 minutes is set aside for participants to network.
“This was billed as the re-empowerment of neighborhoods. Instead, you can get your pet license,” said Capitol Hill activist Bill Bradburd. “They’re trying to keep this a kumbaya moment. They don’t want angry citizens.”
Murray said he’s trying to reach out to people not traditionally involved in their neighborhoods and to broaden the diversity of activists. And he said he’s trying to find a balance between empowerment and a lack of civility that sometimes characterizes discussions about how the city should grow.
“We’re trying to find the place that allows neighborhoods to influence the future character of their neighborhood without giving them veto power over the final decisions,” Murray said.
Summit planners say they reached out to PTA groups, mom groups, block watches, senior organizations, the city’s boards and commissions, and enlisted help from the Office of Immigrant and Refugee Affairs.
Four hundred people have RSVP’d for the summit, and the venue was switched from a room at Seattle Center that held 200 people to the center’s Exhibition Hall, which can hold at least 1,000.
Some neighborhood leaders support the attempt to involve new people. Chas Redmond, past chair of the City Neighborhood Council, said it’s been almost 30 years since the city created the District Council system, which divides Seattle into geographic districts with volunteer representatives elected by their neighborhoods.
The summit, he said, offers a time for “cleaning out the lint and redefinition. I expect a huge crowd. A lot of folks are super excited.”
He suggested that upcoming hearings on revisions to the city’s Comprehensive Plan would be a more appropriate forum for airing grievances about density and growth.
Kiku Hayashi, a past president of the Squire Park Community Council, said she’ll attend Saturday’s summit with “low expectations” and out of sympathy for the city staffers who are organizing the event and planning to sit at department information tables.
But when asked about issues roiling her neighborhood, she pointed to a fight with Swedish Hospital over its proposal to expand its Cherry Hill campus into the adjacent residential blocks.
“You think you’re going to get a hearing from the city, and you end up having to fight them. It’s exhausting,” she said.
John Fox, head of the Seattle Displacement Coalition, which monitors the loss of existing housing, much of it older and more affordable than the new units that replace it, cites city growth targets for 2024 under the state Growth Management Act.
Many neighborhoods are already two or three times over those targets, he said, citing Department of Planning and Development figures.
Those statistics show that, including construction that is already permitted but not yet built, the Pike/Pine corridor is at 347 percent of its 2024 growth target, Ballard at 317 percent and Green Lake at 256 percent.
Fox used the “Neighborhoods 101” label to characterize the summit and said, “There’s little opportunity to air community grievances of any kind, least of all around land use, development and growth — issues that are a source of deep discontent around the city.”
Patrick Tompkins, another Capitol Hill activist, said the “summit” title carries connotations of meaningful dialogue.
“Unfortunately, this is turning out to be a dog-and-pony show with the appearance of engagement with neighbors, after which the city can go back to business as usual,” he said.
Tompkins got involved in his neighborhood when former Mayor Mike McGinn proposed allowing ground-floor retail businesses in low-rise residential neighborhoods.
That proposal was defeated after an uproar from neighbors, but Tompkins said other adjustments to the zoning code are resulting in four- and five-story buildings in neighborhoods zoned for just three floors.
On his block, he said, that’s meant the demolition of an old apartment building and the doubling of rents in another that’s forced out many longtime residents, including some who are elderly and disabled.
He and Fox have joined with other neighborhood groups to form the Coalition for an Affordable and Livable Seattle. The group, which also includes Livable Ballard and West Seattle activists, wants the city to address displacement, gentrification, the lack of developer impact fees, the loss of tree canopy and green space and the lack of city services to support the permitted growth.
At the summit, they plan to gather signatures on a petition to present to the city’s elected leaders.
Donna Hartmann-Miller, a Maple Leaf Community Council member, said Murray was elected on a pledge to stop a 12-year “maligning” of the neighborhoods.
Her own example of an unresponsive city is an attempt to get a crosswalk in place for the 2013 October opening of a new park at Northeast 85th Street and Roosevelt Way. By covering a reservoir, the neighborhood park grew from 5 acres to 20.
She said residents were told they couldn’t even get in line for a crosswalk until the new park opened and the number of pedestrians crossing busy Roosevelt Way Northeast could be documented.
“Parks said it was an SDOT (Seattle Department of Transportation) issue. That’s how they put you off. Can they not talk to each other?” she asked.
She understands the summit is reaching out to less-involved residents and educating them on city process. She said she supports that goal, as a first step.
But more experienced activists, she said, already know the city process and they know the information that’s going to be presented at the summit.
“What we need next is action.”.