A couple of weeks ago I participated in a 48-hour game jam hosted by PlayFab here in Seattle, with fellow procedural planet veteran Alex Peterson, my good friend and composerLeo Langinger, and the fortunate last minute addition of artistBrent Rawls.
We were both surprised and excited to have won this game jam, especially given the number and quality of competing entries.
Our entry, the somewhat awkwardly-named Mad-scien-tile-ology, is a Unity-powered take on the classical 'match-3' game (a la Bejeweled or Candy Crush), with the addition of an all-consuming biological 'creep', which consumes the game board as the player attempts to match tiles in order to slow its inexorable progress:
What went right
- Separation of responsibilities
We had what I can only describe as an optimal team composition for such a short development cycle. Leo was able to focus on composing the music with a little sound design on the side, while Brent concentrated on the artwork, Alex handled all of the UI programming, and I wrote the gameplay logic.
- Time management
We hit the ground running, with an initial match-3 prototype playable early Saturday morning. Thereafter we went into planning mode, and white boarded the roadmap and scheduled checkpoints throughout the day for each deliverable and each integration point for assets. While the estimates weren't perfect, and we missed on a solid handful of items, the organisation helped us to hit 90% of what we set out to do, and still get 2 relatively decent nights of sleep during the competition.
- Building on Unity
Alex and I have both played around with Unity in the past, but neither of us had never shipped a full game thereon. Unity represented a fantastic time savings over building a game from scratch, and the asset pipeline alone saved us hours in wiring up the animations and audio.
- Having an artist, and an unusual artstyle
We hit on the idea of stop-motion papercraft before finding Brent, but honestly were it not for his efforts it would have been a disaster. Brent ran with the idea and produced visuals which are striking and unusual. The real-world textures of the paper, the bold colour palette and the stop-motion animations really help the game stand out from other games of this type.
- Having a composer, and an original score
It's easy to underestimate the impact of music on a video game, and as one of the only teams with a professional composer, I think we had an advantage out of the gate. Leo composed original scores for the title screen, gameplay loop, and victory/loss conditions. The upbeat and detailed music really helps sell the 'mad science' theme, and between composing he was able to produce a full range of foley effects for gameplay events that really help to sell the action on screen.
- Playtesting, playtesting, playtesting
We had a playable (if minimal) match-3 game from mid Saturday morning, and that allowed us to play test each new element as we added it. This can be a double-edged sword - when short on time, you can find yourself playing the game instead of implementing features, but it did give us a good idea of what did and didn't work in the context of the game, and allowed us to fit at least some balance tweaks into the time available.
The scrumboard
What didn't go so well
- Version control + Unity = not so good
We are used to working with a variety of distributed version control systems, so at the start of the competition we threw everything into a git repository and went to town. Unfortunately, we quickly learned that Unity isn't terribly well suited to git. While all the source files and assets are handled just fine, a great deal of the configuration and logical wiring is contained in the single main.scene file, and being a binary file, git only sees it as an opaque blob. After a couple of merges that resulted in having to rewire assets by hand, we had to fall back to editing separate scene files and copy/pasting to the main scene file before we merged.
- Time is the enemy
48-hours is not a long time, and irrespective of our planning, time grew increasingly tight as the competition progressed. While we were able to finish the game to a point we were fairly happy with, a number of features fell to the wayside, most notably highscores. We had intended to implement online leaderboards using our host PlayFab's SDK, but that work had to be deprioritised to make time to fix critical gameplay bugs, and eventually we ran out of time.
- Last-minute changes are not your friend
This one largely follows from the last two points, but Alex and I both tweaked different elements right before we packaged the game for judging, and somewhere in our merge we managed to lose the explosion effect for the player's super-meter, as well as drastically increasing the pace and difficulty of the game in the final build. Neither change badly affected our ability to demonstrate the game, but it's a lesson learned to put the pencils down and focus on testing in the final hours.
- Always be prepared to talk
Winning the contest came out of left field, and the surprise coupled with a general lack of sleep had us roughly ad libbing our acceptance, and the subsequent quotes for the organiser's press release. While one wouldn't assume to win any competition, it turns out to be worth putting a few minutes of thought into what you would say if you do. Even a couple of sentences helps smooth over that deer-in-the-headlights moment.
Video game art 101
What's next?
We're working on getting some of the more egregious bugs fixed, but if you're of a mind to see how it is all put together, the source code and unity project is available over on GitLab. I don't have binaries available for download yet, but we'll try and make it available in a playable form when we have a few more of the kinks worked out.
And I'd be remiss if I didn't give a shout out to PlayFab, for hosting (and catering!) a fantastic game jam, and our fellow competitors, who build some truly amazing games. Here's looking forward to next time.
Jam attendees checking out our game after the competition
- Read more...
- 378 views