Distant Lands Coffee
One of the largest private label specialty coffee suppliers in the US continues to find new ways to bring the highest quality product to consumers. Founded in 1982, Distant Lands is the only vertically integrated specialty coffee company in the US. With more than 30 years of farming experience and more than 20 years of roasting experience, the company has developed a seed-to-cup business structure that begins by maintaining close contact with coffee farms and mills across the world.
“In addition to the farms and mills we own, we have direct relationships with farmers and coffee producers, and these relationships enable us to control the quality of our product, as well as provide us with complete traceability of our coffees,” said Craig Hope, president of sales. “We control the ‘QA/QC’ process from the farm or mill that produces the coffee in the source country through to the consumer, which means we have control of the quality of the supply going to our customers.”
In addition to growing its own coffee, Distant Lands mills and imports green coffee and roasts a finished product that works toward the company’s ultimate goal, which is to build brands for companies’ specialty coffee lines. Hope said the company’s approach to building a strong customer base is the same as its approach to developing the perfect coffee product.
“We look for customers that believe in quality and want to build their corporate brand and go-to-market strategy on a foundation of quality,” he said. “In our interactions with our customers, our brand-building techniques focus on product, promotion, placement, and price, as well as a full disclosure and partnership on the costs involved.”
Perfect blend
Distant Lands’ customer base includes some of the larger foodservice and retail customers in the US. Part of the company’s ability to handle both foodservice and retail customers comes from a November 2006 merger with Java Trading. Hope said the merger gave Distant Lands additional capabilities from roasting and sourcing perspectives but also fused the talents of the two companies together into a perfect blend.
“We had a strong foodservice advantage from our headquarters in Tyler, Texas, and Java Trading had talent from a retail perspective from its headquarters in Washington state,” he said. “The merger also gave us an advantage to be able to roast on the West Coast and in the central US.”
The combined companies have expertise in producing coffee at origin, food service customer relationships, and private label retail brands. Java Trading’s retail experience came primarily from working with supermarkets and mass merchants such as SuperValu and Safeway. By blending those packaging talents with Distant Lands’ experience with foodservice companies such as Panera Bread and McDonald’s, the company developed a stronger go-to-market strategy.
Hope said the end result of the merger was an improved benefit to customers and employees. “For our customers, it gives them assurance that not only is the supply and quality of their product being managed all the way back to the farms, they have complete visibility to the supply chain,” he said.
“All of our significant customers have visited our origin operations and seen firsthand how we produce their coffees,” he continued. “They’ve met face to face with the farmers who grow their coffee. For our employees, it opened up the door to new possibilities because it strengthened our business model.”
Sourcing approach
Distant Lands uses a specific sourcing approach to finding and producing its coffee beans. With nine coffee farms and four coffee mills located in Central and South America supplemented by joint ventures in almost every significant specialty-coffee-producing country in the world, Distant Lands has unequaled access to the production of specialty-grade green coffee.
According to Hope, Distant Land’s philosophy at origin is quite simple: “We reward coffee farmers and millers for producing quality in a long-term sustainable manner,” he said. This has allowed Distant Lands to produce and ship more than 50 million pounds of top grade specialty coffee each year.
“It comes back to how we procure and sort our coffee, but it’s also that we have two of our own roasting facilities, co-packing capabilities inhouse, and a strong go-to-market strategy,” he said. “Specialty coffee is our only business, and we don’t delude ourselves by producing canned coffee or moving our focus away from specialty.”
To capably tackle both the foodservice and retail industries and maintain its tight hold on quality, Distant Lands recently invested in new packaging lines and roasters to keep up with the capacity needed to handle its new customers and maintain consistency in the supply chain.
As a private label manufacturer, Distant Lands handles each of its customers’ brands very carefully from quality and cost perspectives. “All of our customers are experiencing high single-digit or double-digit repeat purchase patterns right now,” said Hope. “By investing in all of our vertically aligned capabilities that streamline costs and bring a high quality product to consumers, everyone benefits.”
Brighter tomorrow
Operational efficiency is important, but Distant Lands recognizes the importance of sustainability initiatives to its business and those who work for it. The heart of the company’s farming operations is Hacienda La Minita, which is considered by many to be one of the world’s finest coffee estates and a model for the production of sustainable high quality coffee. Distant Land’s Rio Negro farm was the first coffee farm in Costa Rica to be certified by Rainforest Alliance, and both farms maintain housing for their full-time workers and migratory harvesters, as well as private medical and dental clinics. The farms also maintain more than 25% of the arable land as forest preserves, providing habitat for many species of animals and vegetation, and carefully managed terracing and drainage systems protect the farms against soil erosion.
Distant Lands’ coffee beneficios, where coffee fruit is converted to exportable green coffee, continue the company’s commitment to quality and sustainability. “We use biomass furnaces to dry our coffee,” said Hope. “These furnaces use only coffee parchment to generate heat, virtually eliminating the need for wood.”
Hydroelectric plants are set up at each mill to produce the electricity needed to run the facilities. Sophisticated water processing technology is used to ensure that all the water required to process the coffee is returned to the surrounding water systems in pristine condition.
“Our sustainability initiatives illustrate our passion for quality and people,” he continued. “We don’t wait for people to bring us new ideas; we bring new ideas to them to grow their businesses with their consumers. It’s about merging resources to make the right decisions for today and tomorrow’s business.”