Every Christmas, retailer’s shelves fill with bigger, more complex and pricier “smart” and internet-connected children’s toys.
Electronic gimmicks in toys are not exactly novel, but is there more going on inside these devices now that parents should be aware of before they buy?
In fact, an accumulation of evidence suggests buyers should be very cautious for reasons that mirror the troubles that in recent years have the engulfed Internet of Things (IoT) sector, of which connected toys are one part.
These being:
- Is the personal data they collect at risk?
- Can they be directly hijacked or interact with, or spy on, children?
- Or even used to carry out attacks on third parties?
Let’s start with the issue of personal data.
The warning flag for this was raised in 2015 when Hong Kong toy maker VTech suffered a data breach that compromised the personal data of 4.8m user accounts connected to 6.3m children.
Beyond several technical failings, it didn’t exactly inspire confidence when the company later tried to shift responsibility for any future breach to its customers by changing its terms & conditions to read:
You acknowledge and agree that any information you send or receive during your use of the site may not be secure and may be intercepted or later acquired by unauthorized parties.
Essentially, if we screw up it’s your problem for trusting us. This was probably unenforceable but class-action legal cases from this breach rumble on even today.
Our first advice, then, is where a toy is used with an app or online service, check the terms and conditions very carefully for sneaky get outs and view any you find as a very bad sign.
Proving this was no one-off, in 2017 US company Spiral Toys’ CloudPets stuffed toys suffered a breach exposing a database of 2.2m voice messages to hackers.
Worse, the researcher who discovered it was ignored by Spiral Toys when he tried to warn them of the issue.
And toy surveillance?
Around the same time, Germany’s Federal Network Agency put out a warning that the popular Genesis Toys’ My Friend Cayla doll could be used to spy on children or, indeed, anyone within range.
The German authorities didn’t mess around. Said a spokesperson:
Ownership of this device is illegal.
By Christmas 2017, it seems connected toys continue to be easy meat for researchers to pick holes in, big and small. Take Hasbro’s Furby Connect, for instance, which had its deficient BlueTooth security design pulled apart by a UK penetration testing company.
More serious flaws were found by another research company in toys using Wi-Fi, not to mention flaky firmware updating, poorly-secured smart watches, and vulnerable drones whose data was open to interception.
Like it or lump it, there is no way for anyone buying a connected toy to know how well it is secured, either locally or when any data it collects is sent to remote servers.
If it isn’t well secured, there is no guarantee the problem will be fixed or even acknowledged – it’s almost as if the economics of the industry don’t justify such a thing for a toy costing less than $50.
Retailers, meanwhile, don’t see security flaws as a reason to take toys back beyond specified time periods.
Our second advice, then, is to run a search on a toy and its maker to research known issues before buying it.
A final issue is whether toys might become another platform for device hijacking of the sort that fuelled the Mirai DDoS botnet in 2016.
For now, the threat of “toybots” seems overblown. Toys are not turned on for long enough and the vast majority lack enough processing power or battery life to run the sort of software that makes such things possible.
But let’s not praise them with faint damnation – even the ones that work as advertised have a growing ability to collect data on young people that’s surprisingly hard to quantify or monitor. Most of this will be buried in terms & conditions that people rarely bother to read.
Parents should try and keep in mind that as far as children are concerned, being smart isn’t the only game in town.
Lego anyone?
2 comments on “Toys: they’re getting smarter, but are they secure?”
Thank goodness Germany is banning toys for the same function that Echo and Alexa have, which is legal. That way they can still have a data sniffer in the house, ensure parents are heard also and not just children. Why is that so, all I can think of is so the entire house can be spied upon and of course the revenue from sales 😮
Maybe if the Cayla doll looked like a fancy trash can and could bill your CC it would be legal. Oh wait, then it would be an echo of Alexa…
Germany is banning these toys because they conceal the functions that could be used for spying. They have strong laws against such things because they are serious about protecting people from surveillance – used by the Nazis, and later by the Stasi in the East. Echo and Alexa are designed specifically and clearly for intereactive functions so are not concealed. Other countries should follow the German lead, which can only serve to improve personal safety and has nothing to do with sales revenue.