This year, there is a widespread implementation of the Common Core Standards in schools.
LOUISVILLE — Standing in her classroom surrounded by place-value boards and colorful chips, Kathy Young looks over the desks of her fifth-graders and reminds them how to write multi-digit whole numbers using the standard form, word form and expanded form.
STORY: Ky. schools look to Singapore for math help
EDITORIAL: Myths fuel attacks on Common Core."
Since 2010, 45 states and the District of Columbia have agreed to adopt the Common Core Standards and have agreed to test students on them by 2014-15, but implementation has been slow — until now.
This fall, 21 states will fully implement the standards in reading and math across all grade levels, joining seven other states and the District of Columbia already using them in classrooms. Seventeen other states will implement the new standards over the next few years. Four states — Alaska, Nebraska, Texas and Virginia have not adopted the standards — and Minnesota has adopted them for English only.
"This school year marks the first time there is a large-scale, widespread implementation of the Common Core Standards across the country," said Michael Cohen, president of Achieve, a bipartisan, non-profit organization founded by governors and the nation's business leaders. "Some states have taken longer than others, and that's OK. This is not a race. This is a way to improve education."
The large-scale implementation comes as politicians in some states have tried to halt it over cost issues and uncertainty over whether the new standards are what's best for their state.
In Indiana this year, kindergarten and first-grade teachers were teaching the standards when state lawmakers agreed to pause overall implementation of the standards pending a legislative review. Similar bills aimed at stopping the standards in Alabama, Kansas, Missouri and South Carolina failed this past year. More bills are likely to be introduced in 2014.
Some conservative groups and other opponents of the new academic standards see the Common Core as an attempt by the federal government to co-opt education.
"This comes across as another large-scale centralized program to try and improve education, and it comes at the expense of parents, taxpayers and educators who are trying to have a voice as to what is taught in their schools," said Lindsey Burke, an education fellow at the Heritage Foundation, a conservative think tank in Washington. "The last thing we need are standards being set in Washington at the expense of state and local control of education."
Over the past few years, federal lawmakers have given $4.35 billion in Race to the Top grant money as an incentive to states that adopt the standards, and they have made Common Core adoption a significant factor in obtaining a waiver from the requirements of No Child Left Behind.
Other opposition comes from educators and researchers who say the standards are not legitimate.
"These standards are inferior to what we need in this country — they are not rigorous, they are not internationally comparable and they are not research-based," said Sandra Stotsky, a professor at the University of Arkansas who served on the Common Core Validation Committee and was one of four committee members who did not sign off on the standards.
Another issue at hand is testing. Supporters hope assessments tied to the new standards will boost achievement on standardized tests and prove American students can compete with their global counterparts.
Testing expert Robert Schaffer with the National Center for Fair and Open Testing said the initial hype with Common Core was that it would result in a new breed of tests that get beyond "multiple-choice bubble."
"The reality is the tests being developed are the same as they have been in the past," he said.
Only two states — Kentucky and New York — have tested on the new standards and the initial results were grim. In both states, fewer than a third of students in grades three through eight scored proficient in math and reading on the new tests.
"It's true that the number of students who scored proficient on our new state assessments did go down, but that isn't because they are not making progress — it is because we are measuring them against higher standards," said Kentucky Education Commissioner Terry Holliday, a supporter of the Common Core who is president-elect of the Council of Chief State School Officers.
"It would certainly be more enjoyable for me to keep the tests the way they were and see more students receive higher scores, but it would also be wrong," he said. "We do our students no favors when we tell them they are ready to succeed in the world when they are not."
Cohen says the results will improve.
"As teachers become increasingly skilled at implementing the standards in their classrooms, our students will do better on the tests and be better prepared for their future," he said.
Antoinette Konz also reports for The (Louisville, Ky.) Courier-Journal.
Join the Conversation
To find out more about Facebook commenting please read the Conversation Guidelines and FAQs