I am likely one of the strongest opponents to what is commonly called “Digital Rights Management” (DRM) that you will come across. Given this, you might assume that I would be cheering now that all 4 of the major music labels – EMI (Britain), Vivendi Universal (France), Sony BMG (Japan and Germany) and Warner Music (US) – are selling their music online free of “DRM”.DRM being applied to content such as music has not been the source of the problem, so this change isn’t a sign of the problems caused by DRM are going away.The acronym DRM is being used for many things, some of which are controversial, and some of which are not. The form of DRM I am opposed to come down to technical protection measures (TPMs, sometimes called digital locks) being applied to two things: content and devices.When I am explaining DRM to politicians, I feel of which they are less aware that is the source of most of the controversy. The TPM applied to content is used to reduce interoperability to only specific access devices. Commonly this means encrypting the content such that a specific decryption key is needed, and then only offering decryption keys to specific device manufacturers that agree to limit the features of their hardware.It is not possible for a TPM applied to content to “make decisions”. It is no more possible for encoded digital content to “decide” not to allow itself to be copied any more than it is possible for a paperback book to read itself out loud. Either the content can be accessed or it cannot.The TPM applied to devices is where the decisions are made, and where most of the controversies are. LAFKON publishing made a video on “Trusted Computing” a few years back to explain the concept. Digital locks are used to lock out those who are not trusted. Computer security is all about the owners of the devices being able to lock out untrusted third parties from being able to access or control the computers. “DRM” is all about someone other than the owner, such as a device manufacturer, locking down the device and treating the owner as untrustworthy. While the identical technology is used such as cryptography, DRM and computer security have the opposite goals from the perspective of the owner of the device.Once you revoke reasonable ownership rights by locking the owner out, many problems will inevitably result. These devices will deliberately not be under the control of their owners, leaving someone else to decide what software runs on the device. That someone else can disallow the owner from using the device in legal ways, or they can violate the privacy and other rights of the owner. The point is not to say that these third parties will always violate privacy rights and disallow lawful uses of the device, but that the ability to make these choices is revoked from the owner and put into the hands of the device manufacturer.The purpose of the first lock is in fact to manipulate the market to encourage people to purchase locked down devices. In terms of current law, this is discussed in section 77 of our Competition Act which recognized that leverage market control in one area (such as the major labels historical control over a majority of recorded music) to manipulate a separate market (the market for home computer operating systems, and portable audio devices) would be harmful, and should be illegal.While this questionably legal technique should have been investigated, it turns out that the lack of interoperability between vendors has been harming the labels themselves. They have noticed that the tie between music purchased at the iTunes music store to the extremely popular iPod device has given Apple considerable market power. This has not only been driving people to Apple, but driving people not willing to purchase content that is tied to specific devices to competing independent labels and unsigned artists. I am a customer of eMusic and never considered any of the DRM-infected music stores that sell major label music.The major labels are now abusing this market harm to their own advantage by selling DRM-free music on stores such as Amazon, but not allowing Apple to sell the same music without DRM. The purpose is to allow the labels to leverage their market control to drive music fans to Apple competitors. This is itself a questionably legal market manipulation technique, suggesting the major labels learned absolutely nothing from Payola.Even if not a single piece of content was DRM-encoded, DRM applied to our devices would still cause nearly the identical harm. While the major labels are removing DRM from their content, they are still actively lobbying for legal protection for DRM being applied to devices, and are likely pushing in the back rooms for governments to mandate DRM on all consumer electronics.This shouldn’t seem far fetched, as this was already proposed by the major television and movie studios in the United States under the name “Broadcast Flag”. This would be a law that said that any device capable of receiving digital television must obey a flag that is added to the unencrypted digital television signal. This would mean that no device which allowed owner control over the device would be allowed — the concept of “no user serviceable parts inside” would effectively be mandated under law. The concept of owner override would be outlawed.As a software author, my business is dependent on hardware owners being able to make their own software choices, such that they could possibly choose my software. It doesn’t matter that I happen to be a Free Software developer, as disallowing hardware owners from making their own software choices affects all independent software developers.This doesn’t just affect software authors. It should be understood that innovation can effectively be defined as the unauthorized modification of the current state of technology. Any laws which disallow unauthorized modification are effectively chills against the very possibility of innovation.This also doesn’t just affect the marketplace. Once our devices are no longer under owner control, and there is no legally protected “owner override”, then many very harmful things will result. There are whole genres of science fiction that talk about the harm to society of this type of centralized control. Closer to our time, most of the privacy commissioners across Canada have come out in opposition to “DRM”.In the United States we have had Stewart Baker, US Department of Homeland Security’s assistant secretary for policy, suggesting in 2005 that “DRM” has national security implications when he said:
“It’s very important to remember that it’s your intellectual property — it’s not your computer. And in the pursuit of protection of intellectual property, it’s important not to defeat or undermine the security measures that people need to adopt in these days.”
Please do what you can to inform people about this problem. As a tool to help politicians understand we have a Petition to protect Information Technology Property Rights that focuses on this issue.See also the article in the December issue of the Open Source Business Report titled “Protecting Information Technology Property rights”.—Russell McOrmond is a self employed consultant, policy coordinator for CLUE: Canada’s Association for Free/Libre and Open Source Software, co-coordinator for Getting Open Source Logic INto Governments (GOSLING), and host for Digital Copyright Canada.