The U.S. Court of Appeals for the Seventh Circuit recently held that a lender that is on inquiry notice that its security interest in the collateral had been fraudulently conveyed may lose its secured status.
However, the Court also held that the lender's negligence here did not amount to "purposeful avoidance of the truth" sufficient to justify application of the doctrine of equitable subordination, which allows a bankruptcy court to reduce the priority of a claim in bankruptcy.
A copy of the opinion is available at: Link to Opinion
The bankrupt debtor was a cash management firm -- i.e., it invested cash, which had been lent it by persons or firms, in liquid low-risk securities. It also traded on its own account, using money borrowed from two affiliated New York banks to finance the trades.
The debtor improperly pledged securities that it had bought for its customers with their money even though its loans from the banks were used for trading on its own account, in violation of 7 U.S.C. §§ 6d(a)(2) and 6d(b) and its own contracts with it customers, which required the securities to be held in accounts segregated from the debtor's own assets.
In August of 2007, the debtor experienced trading losses that prevented it from both maintaining its collateral with the banks and meeting the demands of its customers for redemption of the securities that the debtor had bought with their assets.
The debtor filed bankruptcy in August of 2007. The banks expressed their intention to liquidate the collateral pledged to secure the credit line, but the bankruptcy trustee objected because he deemed the transfers from customer accounts to collateralize the subject loans to be fraudulent transfers under section 548(a)(1)(A) of the Bankruptcy Code. The reason was that the trustee believed the bank officials knew something unlawful was happening, but looked the other way.
After a 17-day bench trial, the trial judge dismissed the trustee's claim. However, a panel of the Seventh Circuit in a prior appeal reversed, holding the debtor had made fraudulent transfers, and instructing the district judge to decide on remand whether the banks had been on inquiry notice in its dealings with the debtor.
On remand, the district judge did not conduct an evidentiary hearing or make additional findings, instead issuing a "supplemental opinion" which confusingly incorporated by reference his earlier opinion on the merits as well as the Seventh Circuit's prior ruling.
In this second appeal, the Seventh Circuit explained that the district court's supplemental opinion misunderstood "the concept of inquiry notice" because it suggested that as long as the banks "did not believe that [debtor] had pledged customers' assets to secure its loans without the customers' permission, [they were] entitled to accept that security for its loans without any investigation." The Court reasoned that this was error "because inquiry notice is not knowledge of fraud or other wrongdoing but merely knowledge that would lead a reasonable, law-abiding person to inquire further — would make him in other words suspicious enough to conduct a diligent search for possible dirt."
By way of example that the banks were on inquiry notice, the Court explained that a senior employee in an e-mail questioned how the debtor could show so much collateral on its books when its capital was a tiny fraction of the pledged collateral. He specifically stated that he had to assume most of the collateral belonged to someone else. After receiving a non-responsive answer from his subordinates, there was no further investigation.
The Seventh Circuit criticized the district court because although the senior employee never expressly said that he "knew or believed that all of the collateral was for somebody else's benefit" he was still suspicious, which according to the Seventh Circuit "was enough to place him on notice."
In addition to failure to follow an "obvious lead" that put the banks on inquiry notice, the Seventh Circuit reasoned that the district court's findings in its earlier opinion that was reversed "actually prove inquiry notice."
The Court then turned to the second issue on appeal: i.e., "whether the bank's conduct was sufficiently egregious to justify application of the doctrine of equitable subrogation, which allows a bankruptcy court to reduce the priority of a claim in bankruptcy."
Reasoning that "there is general agreement in the case law that the defendant's conduct must be not only 'inequitable' but seriously so ('egregious,' 'tantamount to fraud,' and 'willful' are the most common terms employed) and must harm other creditors", the Court agreed with the district court that the case at bar did not satisfy that high standard because "[t]o suspect potential wrongdoing yet not bother to seek confirmation of one's suspicion is negligent, and negligence has not been thought an adequate basis for imposing equitable subordination."
The Seventh Circuit noted that, while the senior bank official should have followed-up on his suspicions, "he may have thought he'd done so when he communicated his suspicions to colleagues at the bank, and if so then at worst he was negligent."
Because the banks were "on inquiry notice that the assets that [the debtor] had used to secure the … loans had been fraudulently conveyed," the Court ruled that the banks lost their security interest, but retained an unsecured claim. The district court's judgment was affirmed in part, reversed in part and remanded for further proceedings consistent with the Seventh