Profitability Playbook for Printers: 10 Strategies for Success from Industry Sales Leaders
The playbook for running a profitable printing business has changed for companies of all sizes. Keeping pace with required capital investments, investing in new printing technologies, hiring and retaining skilled workers, continual shifts in print demand, finding the right mix of services to build customer loyalty and overcoming intense price competition, all pose threats to print service providers’ (PSPs) profitability.
NAPCO Research (a unit of NAPCO Media, the parent company of Printing Impressions) surveyed readers of Printing Impressions to identify the common practices of PSPs that are experiencing stellar sales growth. Identifying and defining the similarities among firms that are growing sales in a competitive market can serve as a guide or playbook for other companies looking to improve their performance.
Almost 200 PSPs responded to the survey, which was sponsored by the Specialty Graphic Imaging Association (SGIA). This research report focuses on the responses of those firms that reported sales growth of 10% or more in the past 12 months. This article offers high-level findings from the full report.
Customers Demand Speed and Innovation
Survey respondents that experienced sales growth of 10% or more in the past 12 months reported their customers are demanding more complex communication products, shorter turnaround times and seamless service delivery. These respondents reported that growing demands for faster turnarounds, shorter runs, just-in-time ordering, online ordering tools, the ability to print personalized or versioned work and combining print with other media, are increasing more than decreasing (Figure 1).
While most printing companies face these same demands for speed and innovative communication options, PSPs experiencing high sales growth typically invest in new technologies and resources to anticipate and meet their customers’ needs. As a result, their clients tend to demand and expect more from them.
Customers are exerting constant pressure on PSPs to drive down costs and speed up delivery times, which requires making continual investments to improve operational efficiency. In a world where people are connected via digital devices and hence are “always on,” customers expect quick responses to their requests and compressed cycle times. Same-day or two-day turnaround is fast becoming the rule rather than the exception. PSPs reporting double-digital sales growth indicated that, on average, almost one-third of their print work (32%) is produced in less than 24 hours.
A key takeaway is that to accommodate clients’ need for speed and higher productivity, PSPs must focus investments on improving their workflow automation and operational efficiency.
Another important takeaway is the importance of offering clients ways to improve the effectiveness of their communication investments via personalization, media integration, and by linking print with digital media. Because the number of communication options has increased, print customers are challenged with determining the most effective use of media to engage with their clients and enhance the communication experience. This presents an opportunity for PSPs to collaborate with customers to improve the results of printed communications through personalization and integration with digital media.
Leaders Are Adding New Print Applications
Of those respondents reporting double-digit sales growth, 81% reported they are expanding the range of print applications they offer. Expanding print applications is a way to better serve current customers, add new clients and offset the declines from those print applications that are migrating to electronic alternatives. As PSPs look to increase sales, pursuing new print applications is a key way to fill equipment capacity and expand into new markets.
PSPs reporting double-digit sales growth are expanding their print application offerings beyond traditional commercial print work into adjacent markets, such as packaging, and sign and display graphics. While respondents reported high demand for typical commercial work, such as marketing collateral (64%), business cards (44%) and direct mail (36%), they also indicated high demand for applications typically in the realm of other print segments, like signage/wraps/banners (39%) and labels/tags (28%).
As a result of ongoing market conditions, competitive challenges and the need to preserve and grow their businesses, PSPs are expanding client services beyond print. Intense competition, declining print volumes and customer demands to simplify their marketing supply chains by limiting the number of suppliers, are driving PSPs to become a one-stop resource for customers’ communications. Nearly three-quarters of high-sales growth PSPs indicated they are becoming one-stop solutions providers.
In terms of additional services offered, respondents reporting double-digit sales growth offered more services than firms reporting no sales growth or declines. The most common services offered by high-growth firms were art/design/creative (cited by 73%), mailing (69%), fulfillment (65%) and prepress/premedia (52%). These are services PSPs have historically offered to combat price competition by enhancing overall value and forming stronger customer relationships. Today, however, services such as creative, mailing, fulfillment and prepress/premedia are often expected if PSPs want to retain their customer relationships.
Sales growth leaders also tended to offer more sophisticated ancillary offerings, including data-related services, digital asset management, social media marketing, supply chain management (via Web-to-print), Website support and cross-media marketing.
Leveraging Diverse Marketing Tactics
Self-promotional efforts can propel a printing company’s sales and brand awareness. Promotion is one of the 4 Ps of the marketing mix and it centers on communication. Successful PSPs understand that promotional efforts go beyond educating customers about the products and services they offer and demonstrate a provider’s expertise. Sales growth leaders invest in diverse self-promotional efforts that encompass and combine digital media, print and customer engagement events (Figure 2).
More than half of high-growth PSPs use digital media (e.g., corporate Websites, email marketing, social media) to promote and grow their businesses. Websites, email marketing campaigns and social media are excellent ways to create awareness, but they need to be combined with core tools, such as printed direct mail, which showcase multichannel capabilities.
Respondents reporting high sales growth also host events to engage with and educate their customers and prospects; 41% hold open house events and 25% support customer educational sessions. In addition, open houses offer the opportunity to showcase equipment capabilities and staff engagement.
Shifting customer demands, fierce price competition and compressed delivery timeframes have many PSPs struggling to increase sales and profits. Thriving in the future will require commercial printers to change their business and operational practices. And the challenge is determining what changes to undertake.
Click here to access the full results of the free research study "Running a Profitable Printing Business: A Playbook for Defining Strategies and Solutions.