Eyelid problems are common but rarely serious.
A cyst (fluid-filled sac) can sometimes develop on the eyelid, or the eyelid can get inflamed or infected. Changes in the position of the eyelids, such as droopiness, often occur gradually with age.
These problems are usually nothing to worry about. However, see your GP if your eyes are watery or uncomfortable due to an eyelid problem, or if you are worried. Seek urgent medical advice if you also have pain in or around your eye or loss of vision.
The information below should give you an idea of what might be wrong, although it shouldn't be used to self-diagnose your condition.
It covers possible causes for the following eyelid problems, plus specific advice about what to. You can increase the chance of the cyst healing by holding a clean flannel warmed in hot water to the closed eye for five minutes. Repeat this three to four times a day for two weeks.
Speak to your GP if you have a large cyst that doesn't clear up after a couple of months. They can refer you to have it surgically drained. This is a simple procedure carried out under local anaesthetic (your eye area will be numbed). It takes just five minutes and doesn't leave a scar.
Also see your GP if the cyst becomes infected because you may need to take antibiotics to prevent a deep lid infection (cellulitis). include; an allergic reaction, shingles on the face and eye (usually with a rash), and other rare eye problems, which would cause other symptoms such as loss of vision.
Gritty or burning eyes are usually caused by an inflamed lid edge (blepharitis) or dry eye. Symptoms are usually worse in the morning or at the end of the day.
People with blepharitis also have an increased risk of getting meibomian cysts, also called chalazia, in their lid (see above).
Gritty, itchy or flaky lids are irritating, but rarely serious. You can reduce the irritation by keeping the lid clean and using artificial tears. Read about treating blepharitis.
Contact dermatitis is another possible cause of itchy or flaky lids. This is a type of eczema triggered when the skin comes into contact with something you are irritated by or allergic to. For example, your eyelids may be sore and itchy because you're allergic to the eye shadow you've been using or because you've been touching your eyes with fingers painted with nail polish. The condition usually clears up after you stop using the substance your skin is reacting to.
Just like anywhere else on the skin, lumps can occur on the eyelids. Many lumps are simple cysts (see above).
However, see your GP if the lump increases in size, changes colour, has an irregular shape or bleeds. It's possible that the lump could be skin cancer.
If the lump is skin cancer, it may need to be surgically removed. Most skin cancers are basal cell carcinomas and don't spread to other parts of the body, although they continue to grow on the lid.
Less commonly, the lump may be a squamous cell carcinoma, which rarely spreads to other parts of the body.
If the lump is dark in colour, it could be a melanoma, although this is relatively rare. A melanoma will need early treatment because it can spread to other parts of the body and can be dangerous..
See your GP immediately if ptosis comes on rapidly, over days or weeks, or if it's associated with other symptoms, such as headache or vision loss.
The lower eyelid can sometimes droop away from the eye and turn outwards. This is known as an ectropion.
Ectropion can affect just one or both of the lower eyelids. It's usually related to ageing, but can also be associated with sun-damaged facial skin.
In cases of mild ectropion, treatment isn't needed. However, if it's uncomfortable or causes your eye to continually water, surgery may be considered.
Read more about treating ectropion.
Entropion is where the eyelid rolls inwards. It usually affects the lower lids, but it can also affect the upper lids.. A corneal ulcer can form and become infected. Surgery may be needed to correct entropion if it's posing a risk to the health of your eye. This is carried out under local anaesthetic and usually takes less than an hour.
If you have entropion, you should discuss your treatment options with your GP. Consult your GP immediately if your eye becomes painful, red and you lose vision.
Flat yellow patches (plaques) over the upper or lower eyelids are called xanthelasma.
Although these plaques are harmless, they indicate you may have a high cholesterol level. See your GP to assess your risk factors for future blood vessel problems, such as heart attacks and strokes.
It's important to have treatment if you have high cholesterol, high blood sugar (diabetes) and high blood pressure. Stopping smoking will also help reduce your risk of developing future blood vessel problems.
It's quite common and normal for the eyelid to flicker or twitch occasionally, particularly when you're tired.
It's more unusual to have repeated spasms of excessive blinking and involuntary closure of the eyes. This is known as blepharospasm. Each spasm can last for a few seconds to a few minutes.
The exact cause of blepharospasm is unknown. However, the blinking and closure may be triggered by bright light, stress or tiredness.
Severe blepharospasm can be very disabling and embarrassing. However, an effective treatment is available. It involves having small injections of botulinum toxin (Botox) into the facial skin to provide relief. See your GP to discuss this.
Find out more about blepharospasm by reading the US National Eye Institute's facts about blepharospasm.