The first time I saw a brown pelican in North Carolina I was charmed by this odd bird. It may look gawky on land, but when a pelican takes to the skies it is sheer elegance. Undulating as it flies up and down along the shoreline, when a pelican spies food, it stops and dives, straight as an arrow, into the surf.
Brown pelicans can remain in flight for many hours at a time using slow, powerful wing beats. While flying, they draw in their head between their shoulders, stretch out their broad, webbed feet and fly in perfect silence. Also strong swimmers, young pelicans barely able to fly have been timed swimming at 3 miles per hour.
Primarily fish eaters, pelicans require up to 4 pounds of fish a day. They have extremely keen eyesight. Flying over water, sometimes as high as 70 feet, pelicans can spot a single fish. Diving steeply, sometimes submerging themselves completely, pelicans usually come up with a mouthful of fish.
Suspended from the lower half of a pelican’s long, straight bill is a pouch that is used as a dipnet. The pouch holds the pelican’s catch until the water, as much as 3 gallons, is squeezed out. The pouch also serves as a cooling mechanism and as a feeding trough for young pelicans.
Brown pelicans are the smallest pelicans. They range in size from 42–54 inches long, weigh 8–10 pounds and have a wingspan of 6–7 feet. They are recognized by chestnut and white necks, white heads, pale yellow crowns, brown backs, grayish bills and pouches, and black legs and feet.
Pelicans are social and gregarious. Males and females, juveniles and adults, congregate in large flocks for much of the year. Brown pelicans nest in colonies, mostly on small coastal islands which provide protection from predators and flooding. They build their nests on the ground, in bushes or in the tops of trees.
Like many birds, newly hatched pelicans are blind, featherless and completely dependent upon their parents. They soon develop a soft, silky down, followed by feathers. The average age at first flight is 75 days.
The young are fed with great care. Fish are instantly swallowed to be disgorged later for the young. At first, the food is dropped in a well-macerated state into their extended throats; afterward, the fish is given to them in its entirety; and finally, the parent birds merely place it on the edge of the nest.
Though more common to the Southeast, brown pelicans have been nesting in the lower part of the Chesapeake Bay since 1987. More recently, they have moved northward into the mid-Bay.
The first nesting record for the state of Virginia was in 1987. There were 2 breeding sites located that year. Metomkin Island, a barrier island along the seaward margin of the Eastern Shore, had approximately 20 active nests that year. The second site was Fisherman’s Island, the southernmost barrier island at the mouth of the Bay. This site had four active nests that year. Pelicans nested on Metomkin for only one year but have nested on Fisherman’s Island every year since 1989.
In 1993, a survey of colonial waterbirds in coastal Virginia found pelican colonies on Fisherman’s Island and Cheeseman Island, just south of the Maryland/Virginia border. The Fisherman’s Island colony contained 324 nests and the Cheeseman Island colony contained 44 nests. Since that time, the Fisherman’s colony has increased by more than 50 percent. It has been estimated that Virginia currently supports about 500 pelican pairs.
In Maryland, a single colony on a state-owned dredge spoil island in Chincoteague Bay near Assateague Island was active from 1987 through 1995. From 1996 through 1997, there were no brown pelicans nesting in Maryland.
Then, in 1998, the first pelican colony in the Maryland portion of the Bay formed on Spring Island, which is located in shallow water between Bloodsworth and South Marsh islands. This year there are 143 pairs nesting at Spring Island.. DDT, picked up by pelicans eating contaminated fish, caused the birds to lay eggs with shells so thin they broke during incubation.
Several efforts curbed the decline of brown pelicans. The passage of the Migratory Bird Treaty Act in 1918 gave protection to pelicans and other birds and helped curb illegal killing. Studies proving that pelicans were not harming commercial fisheries helped to stop the slaughter. In 1970, the brown pelican was listed as an endangered species, affording them more protection. In 1972, the use of DDT was banned in the United States.
Together, these actions have helped to increase the population of brown pelicans. In 1985, brown pelican populations on the Atlantic coast and in Alabama and Florida recovered to the point where the species could be removed from the Endangered Species List in that part of its range.
Although brown pelicans are doing well on the Atlantic coast, threats still remain. The disturbance of nesting colonies, birds being caught on fish hooks or entangled in monofilament line, and oil or chemical spills still pose a threat to this wonderful bird. However, with care, brown pelicans will continue to nest on islands in the Chesapeake Bay.
For more information on Chesapeake Bay fish and wildlife see:
Dr. Bryan D. Watts, director of Center for Conservation Biology at the College of William and Mary and David Brinker of the Maryland Department of Natural Resources assisted with this article.