Nonstick pan popularity has waned as people have become aware of potential health risks from using nonstick materials at high heat. One alternative to nonstick pans is to use cast iron pans and to “season” them with cooking oil. At high enough temperatures, cooking oils will polymerize, and with enough layers of such polymers you wind up with a thin film of plastic-like, somewhat nonstick material. Over years of use, cast iron will accumulate more and more layers of polymerized oils on the cast iron’s cooking surface. The more layers, the less iron-leaching and the more nonstick the cast iron will become. Even the best-seasoned cast iron is not truly nonstick, but it’s good enough for many people–even for notoriously sticky foods like eggs and fish.
HOW TO SEASON CAST IRON AND CARBON STEEL
The short story is to either a) cook a lot with high-quality organic, preservative-free meats, or b) use the method popularized by Sheryl Canter.
The first method is self-explanatory. Just cook meat at high temperatures, like searing steaks, enough times and the pan will season naturally.
The second method is to wipe a very, very thin layer of flaxseed oil on your cookware–so thin that you can’t see or feel it. Your cookware should look like it has no oil on it at all. Bake your cookware with the film of flaxseed oil for an hour at 500F and repeat several times, cooling for an hour in-between each baking hour. It’s important to get it right or else entire swaths of seasoning may flake off. This is the method I used to seal the rims of my enameled cast iron cookware, by the way, so I would not have to worry as much about rust.
IS SEASONING SAFE?
I am not aware of any major study about the long-term health effects of cooking on seasoned cast iron. That does not mean seasoning is safe or that it is NOT safe. It just means that you should be aware of what seasoning is and make an informed decision:
When an oil is heated to the smoking point, it starts releasing carcinogenic fumes (free radicals), but after a while the fumes stop, and what remains is polymerized oil: plastic.
Is it possible that those carcinogenic free radicals remain in the seasoning?
Yes, during regular cooking. If you’re baking an empty cast iron pan at 500 degree F for an hour, that will probably bake away most or all carcinogens. No problem. But if you’re doing regular cooking like searing a steak, you might heat the oil near or past its smoking temperature, which begins to emit carcinogens. Sure you might then quickly drop the temperature by putting a thick steak in the pan, but some of those carcinogens have already been produced, and I don’t know how much of that attaches to the seasoning. I’m not sure anyone does, because I haven’t seen any scientific studies about it.
Is it possible to inadvertently eat seasoning?
Obviously the answer is yes. Microscopic pieces of seasoning can flake off from the pan into the food.
Is it bad for your health to eat the seasoning?
Eating seasoning is not good for you. Seasoning may contain traces of carcinogenic free radicals. On the other hand, your body has natural defenses against free radicals (antioxidants), and so long as you eat only a little bit of seasoning each day, this may be a nonissue. But by the same token, eating small amounts of Teflon or other PTFE (artificial nonstick material) isn’t going to kill you, either. Teflon is inert and should pass through your body without interacting with anything else. So if you are thinking about switching from Teflon pans to cast iron pans because you read a scare story about allegedly toxic nonstick pans, you should be aware that you could be trading nontoxic Teflon for carcinogenic seasoning, albeit at low levels. (It is true, however, that overheated PTFE will start to emit toxic fumes that can sicken and even kill humans. Never heat a nonstick pan past the maximum temperature that the cookware manufacturer recommends and try to keep it under 400F if you have birds around.)
If you don’t like the idea of possibly eating trace amounts of carcinogens in cast iron seasoning, but don’t want to cook on PTFEs like Teflon, either, then consider a different cooking surface like stainless steel or enamel. Those surfaces will tend to be “stickier,” however. Ceramic nonstick pans are another alternative, but many consumers claim that ceramic loses its nonstick qualities within months of heavy usage. My own studies on this subject are inconclusive.
CARE
Cast iron and carbon steel have lots of iron that will oxidize (rust), especially if left in contact with water. Furthermore, seasoning may come off if you use detergents, which act as chemical go-betweens for oil and water. Therefore, never leave your cast iron/carbon steel soaking in water. It’s okay to wash with hot water, even soapy hot water, if you immediately towel dry and then heat up briefly on the stovetop to get rid of any traces of water left. It’s also okay to simply wipe with a paper towel and perhaps some salt, if that helps get rid of any charred bits stuck to your seasoned pan. You could also use a steel scraper, steel wool, or a piece of chain mail armor
. If you don’t mind plastic, Lodge makes regular plastic scrapers
and ones with teeth
(for grill pans), but they are made out of polycarbonate plastic and thus probably have estrogenically active chemicals in them; therefore if you do use plastic scrapers, make sure you rinse thoroughly in case any microscopic particles of plastic remain in the pan after scraping.
Back to A No-Nonsense Guide to Cookware Materials.