If you have a job opening, you need a job description? Right? Not necessarily! Let’s take a step back and examine the assumption that job descriptions are a useful piece of the recruiting puzzle.
In theory, a job description is just a list of the skills and qualities that a person needs to have in order to succeed in a role. But in reality, there’s something fundamentally wrong with this model. While 72% of hiring managers say they create clear job descriptions, only 36% of candidates agree, according to a 2016 survey conducted by the Allegis Group. That’s a really big disconnect between how companies and candidates perceive the match between the skills listed on a job description and the skills actually necessary to do well at a job.
The issue is that even the most thoughtful, well-written job descriptions are flawed from the outset. That’s because job descriptions:
- Are unrealistic: At a lot of companies, job descriptions end up becoming a wish-list that has very little to do with the actual skills necessary to do the job. Every stakeholder in the process adds more and more nice-to-haves, until they end up obscuring the genuine must-haves.
- Are misaligned: There’s often a discrepancy between the skills listed on a job description and the skills that are tested during the interview process. This is very prevalent for technical roles, where interviews often focus on algorithmic or data structure questions that have little to do with the job at hand.
- Are limiting: Job descriptions contain details that seem major to a job seeker, but aren’t actually important at all. So, a fully qualified candidate might not apply because they don’t have an arbitrary number of years of experience, the right degree, or some other detail that’s ultimately unimportant.
The Future of Talent Recruitment
So, you’re convinced: Job descriptions are one of the leading causes of candidate-role mismatches. They’re a relic of a different time and a different recruiting environment. And it’s time to put them out of their misery.
But what’s the solution?
The ideal solution is a matchmaking platform between qualified candidates and companies that have open roles. If a candidate has a verified skill that is needed to succeed in a certain role, then they’d be matched with that role. This would entirely eliminate the need for external-facing job descriptions.
An accurate assessment mechanism is necessary for a candidate marketplace like this to exist. Knowledge, skill, and ability are all measurable and quantifiable. And if you can quantify them, you can match the right candidates with the right roles with a high level of accuracy. It’s not just candidates that need to be measured, though.
A platform like this would need to have a clear view into the hiring processes and interviews for each of the open roles at the member companies. This is a classic marketplace problem, and it should be solved through a powerful marketplace. Just like Uber and Lyft solved the matchmaking problem between riders and drivers and Airbnb solved the matchmaking problem between travelers and hosts, a platform like this can solve the matchmaking problem between talent and jobs.
What’s stopping companies from implementing a marketplace like this right now? The biggest roadblock is that it’s fully dependent on having verifiable data from both the candidate and the company. Unlike Uber or Airbnb, the amount of data that you need on both sides of a talent marketplace to create viable matches is enormous. Harnessing that much data and being able to put it all together isn’t an easy task.
And unfortunately, there aren’t widespread systems in place right now that can collect the data on both sides of the equation and use it meaningfully. There’s been progress on this front with engineering jobs, since that sort of role requires a verified skillset. For most other types of roles, though, matching talent to roles is still a guessing game.
Focus on Skills to Fix the Job Description
Until technology progresses to the point where you can truly ditch the job description, how can you make them less broken right now? It starts with focusing on the open role itself.
Meet with the hiring manager immediately when you get a new requisition. Instead of letting them give you a wish-list of qualifications, make sure that they’re being realistic about the skills required for someone to succeed in the job.
Dive into the details: What will the person be responsible for doing? What hard skills do they absolutely need to possess, and what skills are nice-to-haves? What level of experience at each skill does a candidate need to have? Are any of these negotiable if the candidate seems like a good fit, otherwise?
Once you’ve come up with this list, think about whether somebody at your company who already works in that role would identify with it. Does it accurately capture their responsibilities and the skills they need to have? If so, great—you have a job description that actually describes the job.
Ultimately, you will uncover the attributes that might not be covered in a traditional job description, but will make or break a candidate’s ability to succeed in the role. The resulting document can be your guiding light as you recruit for this position.
Tigran Sloyan is the founder and CEO of CodeFights Recruiter, a platform that uses machine learning to help companies source, assess, and interview the best technical talent for their open engineering roles. You can follow Tigran on Twitter or connect with him on LinkedIn.