How Small Firms Can Protect Their Interests in R&D Alliances
Small companies with a promising technology or service often look to partner with bigger firms to get access to money, distribution channels and manufacturing facilities they need to help their business and their fortunes grow. For the larger company, an alliance with a smaller firm and access to its proprietary products or services could open up new opportunities to expand into a new market. In theory, R&D alliances allow both firms to combine their knowledge and benefit financially.
But these alliances are not always a win-win. They can present a risk to the smaller firm: that in the process of partnering with the Goliath, they may lose trade secrets and talent and undermine their own interests long term. One of the problems is that bigger firms typically do the choosing: they look for small firms with resources that can benefit them through a partnership, then actively court them by dangling the investment that smaller firms often need. The Goliaths also have more partnership experiences and resources than the Davids, and thus can and do tuck clauses into an agreement that give them loopholes, sometimes in a non-obvious way. One common but sometimes unforeseen result is “learning by hiring,” when the larger firm poaches the smaller firm’s best people to give them quick access to the small firm’s trade secrets and proprietary knowledge.
Fortunately, research that we’ve published this year found that a properly structured alliance contract can help small firms protect their interests, while still allowing for communication and coordination with the larger firm. The key is anticipating circumstances where the smaller firm is vulnerable to losing people or knowledge, then crafting language that prohibits such losses.
About TCE
We used the theory of Transaction Cost Economics (TCE) as a lens for our research. TCE examines the hazards that lurk in individual transactions. If they’re smart, parties in a contract are aware of these risks to their firm and push for clauses that minimize them. And because often the two parties’ goals are not perfectly aligned, the other party will push back if the clause may pose a risk to them. This becomes especially important when the knowledge bases of both parties are dissimilar, and each firm seeks to protect its secrets while still sharing enough to make the alliance productive.
What We Studied
Our research studied 136 contracts between companies partnering on new medical devices, with each partnership involving a large company and a small one, between 1994 and 2011. R&D alliances are far more common in the medical device industry than joint ventures are. Many of these alliances were between companies with different specialties, such as manufacturing or developing biological and pharmaceutical products, that both wanted a stake in the medical devices space. We compared the patent classes cited in the patents filed by the partnering firms to figure out how dissimilar their knowledge bases were. We also looked at each firm’s financials and whether the big firm made an equity investment or paid licensing fees, R&D fees or royalties to the smaller firm.
On the whole, we found that bigger firms were far older and wealthier than the smaller ones. On average, the smaller partners were 11.2 years old and had $56 million in total assets; the larger firms were nearly 50 years old and had $27.8 billion in assets.
What we Found
From looking at different aspects of the 136 alliance contracts to figure out the possible risk, we found some devils in the details. For example, we looked at the terms for giving each party access to the other’s facilities, and found that some of these agreements were one way: employees from the big firm could visit the smaller firm’s premises at any time, but not the other way around. We also saw that “non-solicitation” clauses, which prevent one firm from poaching talent from the other, were similarly one way, favoring the bigger firm or giving them loopholes to get around it.
The power balance shifted to the smaller firm in cases where the smaller firm had a large number of patents. It gave them more incentive to protect that knowledge by paying attention to the wording of the alliance contract.
Takeaways
Our research can provide some guidance for smaller firms being courted by bigger ones for R&D alliances.
- Bargaining power is not always about size. If as a smaller firm you have a large number of patents or proprietary knowledge that the larger firm covets, you already have the upper hand in protecting your interests. Make sure you know the full extent of what you have to offer.
- You may find that giving the bigger firm access to your facilities and your people is the best way to share your knowledge with them, towards the end goal of a profitable new product or service. If you give them access, make sure to place some boundaries on who they can talk to and what they can see. You may also want to negotiate for similar rights to their facilities and people.
- Your key technical people are critical to your growth and survival. Have a robust, legally sound non-solicitation clause that will prevent your best talent from defecting. Get legal help if you don’t have it in-house.
Pattit, J.M. and Deeds, D.L.: "Knowledge Dissimilarity, Bargaining Power, and Smaller Firms' Ability to Negotiate a Favorable Alliance Contract," Journal of Engineering and Technology Management, Oct.-Dec. 2021