How Can Healthcare Big Data Analytics Bust Data Silos?
- While end-user clinicians may be frustrated by gaps and blank spaces in their patient data, they are not the only ones who are experiencing some degree of consternation when it comes to big data analytics. Before a physician or nurse even sees a lab result pop up in their EHR, the data has traveled along a complex and convoluted path to get there. More often than not, this data has encountered at least one impenetrable obstacle - a data silo - that keeps it locked in place and inaccessible to other necessary applications.
Data silos are generally caused by one of two major problems: IT systems that cannot communicate with one another - also known as “walled garden” systems - or individual data elements stored in incompatible formats that cannot mesh regardless of how open the underlying architecture may be.
The healthcare industry broadly describes these shortcomings as “a lack of interoperability.” Many first generation EHR systems generated data in proprietary formats, leaving organizations with historical information that cannot be read by other applications. Even in 2015, as the vendor community comes together around more widely accepted data standards, legacy systems, a dizzying array of data formats, and infrastructure-level workaround are keeping data silos firmly in place.
Organizations with their own IT departments and in-house infrastructure may use a plethora of tools to get their data where it needs to go, and each of these applications must be monitored, managed, and maintained before the data they store and transmit ever reaches the consult room.
IT departments have their own set of performance metrics and quality controls to accomplish this, and they have their own unique way of seeing how data flows - or doesn’t - across the supporting systems that bring eventually bring actionable insights to clinical care. Network engineers and data analysts use wire data, machine data, agent data, and probe data, among other types of information, to illuminate where data silos exist and how to overcome them.
READ MORE: HIMSS Tool Offers New Healthcare Business Intelligence Insights
Wire data is the signature of data in action: the readable footprint of information as it moves across networked systems. It indicates how long data takes to get from one place to another, how reliable a specific system is, and where failures may occur. From a clinician’s perspective, it may be viewed as a type of metadata, which shadows information as it filters upwards towards the EHR.
Machine data, meanwhile, is a record of actions that have already occurred, such as call logs or EHR access time stamps. This data is more or less static, and while it may recount the activities of users, it is automatically created by IT systems without much human intervention. When subjected to more sophisticated analysis, the millions of data points in machine data can help a healthcare organization identify a possible breach or chart how long a clinician takes to see her patients, and even aid understanding of how patients flow into the emergency room or how often a nurse updates vital signs.
Correctly and efficiently analyzing these types of big data is key for clinical and business intelligence activities, and can help healthcare organizations understand how their IT infrastructure can enable workflow improvements and deeper insights into their clinical, financial, and operational data.
A new survey from ExtraHop shows that organizations are increasingly combining big data sources to flag possible silos and eliminate them. Sixty-five percent of the Fortune 1000 organizations participating in the survey are using multiple big data sources for IT operations analytics (ITOA) that underpin the discovery and abolition of data silos. Just over half of these organizations are using wire and machine data to generate insights. Only nine percent of respondents have no plans to invest in these capabilities within the next two years.
“As awareness of big data matures, we are seeing faster and more widespread adoption of ITOA technology, and the importance of wire data as a source of insight has become a key topic in conversations with our customers,” said Jesse Rothstein, CEO of ExtraHop. “Businesses rely on IT as the lifeblood of their organizations, so the stakes are high for keeping that machine running as efficiently as possible. That’s where ITOA has really proven itself as a high-value, must-have initiative.”
READ MORE: 10 Healthcare Big Data Analytics Outsourcing Mistakes to Avoid
Wire data is viewed as particularly useful for silo-busting activities, due to its high degree of availability and reliability. Nearly three-quarters of survey respondents said that wire data is one of the most comprehensive data sources available, since it includes records of every data transaction that occurs. A similar number said that its objectivity is also a highlight, while sixty-seven percent said that they can monitor and analyze wire data without installing extra tools or specialized applications.
While wire data falls mainly under the purview of network engineers, it is important for clinical end users to understand the significance and impact of what the IT department is doing below stairs. ITOA activities help to prevent application downtime, maintain network security, manage capacity issues, and get to the root cause of technical problems.
Developing the big data analytics techniques to dig even deeper into this information is a top priority for nearly all participants. Ninety-three percent of survey respondents said that wire data is “foundational” to their ITOA strategies.
“We’ve been able to detect so much more than we anticipated: what applications are talking to, where SSL certs are installed, what servers are doing that they shouldn’t be, et cetera,” said an IT director at a healthcare company.
“Without wire data, you’re missing out on a huge amount of useful information,” added an engineer at another organization.
READ MORE: Cloud Big Data Analytics Adoption Accelerating in Healthcare
By taking a deep dive into wire and machine data, healthcare organizations may be able to identify and correct blockages that lead to frustrating data silos. Integrating disparate IT systems is a critical step for achieving the interoperability desired by clinical end users, and this task can only be accomplished when network architects and engineers have a comprehensive understanding of how data moves within existing infrastructure.
As big data analytics becomes more sophisticated in healthcare, these vital data sources, combined with strong governance frameworks and continued investment, may be the keys that unlock the high level of business intelligence and operational efficiency desired by the majority of healthcare organizations today.