In previous blogs I have discussed the rationale (or lack thereof) for certain tests, for certain questions in the medical history, and for the annual physical exam. Here I wish to discuss a more difficult question: the reason for performing certain screening tests. Again, let me emphasize that I am only talking about how a given screening test benefits the individual, and not how performing the test on the individual would benefit society. Whether or not an individual patient should submit to (and possibly pay for) a test that the doctor knows would only benefit society and not the patient is an interesting philosophical and ethical question, but that discussion is outside the scope of this blog. Needless to say the question of cost-effectiveness will not enter into my discussion, since if I am restricting myself to the direct benefit to the patient, the ultimate cost to society should be outside my purview. For the sake of this discussion, I will also assume that the test is 100 per cent accurate, with no false positives or negatives. I realize that this assumption is similar to assuming a straight line has no width, but the minute we admit the existence of errors in screening tests, the discussion has to include statistical probabilities as well as the incidence of the disease being screened for, and I am trying to keep this presentation as uncluttered as possible. I am also deliberately omitting any discussion of the optimum interval between tests, since there is virtually no hard data on this point for any test.
The problem, of course, with this minimal set of assumptions, is that we now have a reason for doing any test for which there is a treatment that can avert morbidity or death. A chest Xray could show unsuspected tuberculosis, a blood test could show unsuspected mercury poisoning, and an EKG could show a regular rhythm with unsuspected 2:1 block. Again, we are not interested in the probabilities of these diseases, but only with finding them. And of course if you asked the patient if he/she wanted to be tested for TB or elevated Hg+ or a cardiac arrhythmia, the answer would be "yes" in all instances. And if you as the patient's doctor knew in advance that a certain test would demonstrate a treatable condition, you would be morally and legally wrong not to order the test. So how do doctors decide which tests to do or not to do?
Unfortunately for the purist, this is where statistical probabilities and the doctor's diagnostic acumen and level of disease suspicion enter. Should every patient dwelling in the northeastern United States or certain other geographical areas have a western blot test for Lyme disease and babesiosis? Should every sexually active patient be tested for syphilis and HIV? Should every woman of child-bearing age receive a blood test for pregnancy before every Xray? Since at autopsy 10% of males at age 40 have coronary artery disease should every male have a stress-thallium at this age? Should everyone have a flexible sigmoidoscopy (which requires virtually no cleanout, unlike a colonoscopy) at age 30 to look for colon cancer? Shouldn't everyone have a skin test for tuberculosis? Shouldn't everyone receive an echocardiogram to look for IHSS and an abdominal USG to look for an abdominal aortic aneurysm?
After the tests are done, we then have methodological questions: At what level of fasting glucose should we label a patient as "pre-diabetic"? At what level of fasting glucose should we start pharmacological treatment, and what glucose level should be our goal? Since the risk of stroke and heart disease increases monotonically with systolic blood pressure, at what number should we start to treat blood pressure, and to what number do we wish to reduce it? To what number should the cholesterol be lowered? If we start to treat a patient, how often should the patient be retested? When a government-sponsored panel of doctors makes a health recommendation, why aren't we told the vote? (I am much more confident in following a 19-1 vote than a 12-8 vote.) And why aren't we told the arguments of the doctors who disagreed with the public health recommendation the way we are when the FDA recommends approval of a drug? And do the doctors who voted against the recommendation of the majority of the panel change the way they practice medicine to conform to the recommendation of the panel, even if they think the panel is wrong?
I hope this blog serves in part to show that there is an art of judgment in medicine. In today's topic the judgment lies in deciding which tests to order and which not to order. There is also another art of judgment when the test results come back: how "abnormal" does a blood test or Xray have to be in order to influence the treatment plan of the physician?
Sunday, June 24, 2012
Medical Screening Tests
Posted by george thomas at 6:09 PM
Labels: Medical Screening Tests