Pat or Clap?
Can you figure out motions in a repeating pattern?
Paige began a repeating pattern with pat, clap, clap.
- What could Paige’s next three motions be? Show your thinking.
- What will Paige’s 10th motion be? What about her 20th motion? What about her 50th motion?
- What is a repeating pattern? What could Paige repeat?
- What could Paige do next? After that? And after that? Why does that make sense to you?
- What will the 82nd motion be in Paige’s pattern? What will the 99th motion be in Paige’s pattern?
- How can you determine what any number motion will be without working all the way through the pattern?
- Imagine Paige telling you she was starting a pattern that is different from the one you thought of. What else could her pattern be?
This task asks students to create a repeating pattern given the first three motions of pat, clap, clap. Although not identified by content standards in the Common Core State Standards for Mathematics, describing, duplicating, and extending repeating patterns is foundational for primary students. Patterns and generalizations are at the core of doing mathematics as students engage in repeated reasoning and look for structure across mathematical domains.
While many students may perceive the pattern as an ABB pattern and extend it on this basis, that is not the only solution. In fact, students may generate diverse patterns using these three actions as a starting point. For example, students may:
- Add a pat or a clap to create a four-motion core unit of pat–clap–clap–clap (ABBB) or pat–clap–clap–pat (ABBA)
- Add one or more new motions to create a core unit of four or more motions (e.g, pat–clap–clap–ear tug for an ABBC pattern)
The outcomes for the 10th, 20th, and 50th motions will depend on the repeating pattern that students have created and extended. Students may extend their repeating patterns through the 50th motions, or they may look for predictability in the numbers for the motions. For example, if they extend an ABB pattern, all of the second B’s (the second clap in the pattern’s core) will fall on multiples of 3. These landing points for that motion can be used to identify motions for numbers that are not multiples of 3 by either extending beyond or working backward.
Students may choose to use an app to create an alternative representation of their repeating pattern.
- In the Pattern Shapes app, students might create an equivalent pattern using pattern shapes. For example, if they consider these three motions the start of an ABBC repeating pattern, they might represent and extend the pattern using green triangles (A’s), orange squares (B’s), and blue rhombuses (C’s) (as shown here).
- Alternatively, students might use the Number Frames app to create an equivalent representation of an ABB repeating pattern using counters or other images. They might even use a customized frame structure to duplicate and extend the pattern core and highlight predictable quantities (as shown here).
- The Number Line app provides a structured tool for tracking motions in the repeating pattern. If students create an ABBA pattern using Paige’s first three motions and an added pat, representative labels for these motions can be positioned on the number line and extended through any number of motions (as shown here).
Recognizing, describing, and extending repeating patterns are valuable mathematical activities in their own right. To push students’ thinking further, consider asking them questions that attend to the patterns in positions of specific motions. What do you notice about the pats? How could you predict the next pat or any pat? What do you know about the numbers before or after the pats? Questions such as these will help students extend their thinking about repeating patterns to generalizations related to multiplication and even division with remainders!