I received a copy of a new book published by Packt publishing about mobile security. As mobile devices are more and more targeted by attackers, it was a good idea to publish a book on this hot topic. Written by a group of people working for IBM, the book covers a broad range of topics that can be grouped in two main sections:
- A review of problems and threats affecting mobile devices
- Tips and procedure to protect your mobile devices
Across the book, the two main mobile OS are covered (iOS and Android).
The first part (chapters 1 to 4) covers all the security issues that we can face when using a mobile device (and this can be extended to any “connected” device to be honest). Chapter 1 (“Living in a mobile world“) describes how our lifes changed thanks to (our “because of“) our mobile devices. We are always connected and this makes us more vulnerable to attacks. The second chapter (“Users and Mobile Device Management”) focuses on the solution and procedures that can be deployed to control mobile devices, mainly MDM solutions but also all the requirements around it: procedures, policies. Note that a “MUM” (“Mobile User Management“) could also be very useful in some cases. The third chapters reviews our privacy: “Small Word, Big consequences“. This is maybe the most interesting one. If you just have one chapter to propose to non-IT people, it’s this one! It covered all the issues that we may face regarding our privacy with a lot of references to real cases. Different types of attacks are reviewed in the next chapter: Scams, malwares, SMS spoofing, Social engineering, Phishing, Cloud computer (yes – it’s considered as a threat) and viruses.
Then comes the second section with more defensive advices. the fifth chapter is called “Protecting your mobile devices“. Basically, it’s an overview of all the features implemented by a classic MDM solution: Strong passwords policies, encryption, how to use good apps, remote wiping a device. I’ve to mention some good tips covered like:
- What to do in case of one of your account has been compromised?
- How to create strong passwords? (honestly, nothing new)
- What are the signs that a device has been compromised?
The next chapter looks a bit stranger to me. It covers the support and warranty of mobile phones. I don’t see a direct relation with mobile security! Maybe some interesting advices can be found here if you’re fighting with your mobile operator or manufacturer. The most important fact to keep in mind is the gap between a device owned by a company (owned == supported) and a personal device used in your job (“BYOD“). Same idea for the chapter 7 which covers the baby boomers and teens. It reviews the impact of mobile technologies on children and young adults. It also give some advices to parents who want to make mobile devices safer for their kids.
The last chapter covers the case when you’ve been hacked. How to get your life back? “Your life” is not exaggerated because mobile devices contains so much personal information (contacts, emails, sms, pictures, videos, notes, …). This chapter gives tips like:
- How to make a backup?
- Whom to contact in case of suspicious activity?
- How to wipe? (partial vs complete)
Then the book ended with some annexes. The first one cover IBM NotesTraveler, a email push solution for mobile devices. Irrelevant in books like this one which must remain vendor independant (the fact that the authors are working for IBM is not a valid reason). The annexes C gives a checklist of tips to protect your mobile device and the annexe D proposes a template of “Mobile Acceptable User Policy“.
What to conclude? This books contains lot of useful information but you’ve to select them by yourself. If you are only a user, some chapters are worth a read. If you are an IT-guy of looking for a MDM solution, others might be interesting too. I would say: check the table of contents and follow your points of interest!
The books is available online here.
Profile