In 1971, NASA sent three astronauts who were University alumni to the moon as part of the Apollo 15 lunar mission. Now, three University professors have been chosen for a new NASA project, one that believes many answers may be blowing in the wind.
On Monday, NASA announced that a team of Michigan University professors - Christopher Ruf, professor of atmospheric, oceanic and space sciences and electrical engineering and computer sciences; Aaron Ridley, associate professor of atmospheric, oceanic and space sciences; and Derek Posselt, assistant professor of atmospheric, oceanic and space sciences - were chosen to receive $151.7 million over the next five years to undertake their Cyclone Global Navigation Satellite System project.
The project aims to simultaneously launch eight satellites by 2016 that will spend at least two years in space where they will gather data about cyclones and other tropical storms that previous technology found difficult to provide because of the difficulty of studying inside oceanic storms.
The team of professors beat out 18 other teams that submitted proposals when the agency offered an opportunity for funds for small spaceflight investigations in Earth's system, made possible by the Earth Venture-class series of projects in NASA's Earth Science Division.
The University professors will partner with Southwest Research Institute of Texas, Surrey Satellite Technology of Colorado and the NASA Ames Research Center to build the satellites and gather data that can be used for research.
In Earth's orbit, the satellites' functions will include probing the interaction between seawater and air and how that interaction has a role in the development of hurricanes and other tropical storms.
Ruf, the project's principal investigator, said the satellites will be up in space to monitor hurricanes for at least two hurricane seasons but noted that while the satellites are designed for a two-year lifetime, they may last longer.
"The first one is like a training session, to make sure everything is working and tune up all of the electronics properly, and then the second year we'll be able to really do it," Ruf said.
Ruf said their mission was attractive to NASA because their satellites are smaller and less expensive than previous satellites.
"There's several different ways of looking at the surface conditions that have been flying since the 1970s, and the more traditional ways are much bigger and much more expensive," he said.
Ruf added that the satellites' technology will allow for a mission that will be the first of its kind.
"As far as using this kind of technology specifically, it's been demonstrated twice before on satellites, but they were just these little demonstrations, things that only lasted for a few weeks to show that the idea was sound," Ruf said. "But there was never like a full, concerted mission to do sustained science."
Ruf said the team also extensively researched cyclones before submitting the proposal.
"We did a lot of historical analysis ... as part of the design study for how many satellites we would need and the detail about their design so we would be able to see a lot of hurricanes," Ruf said.
The mission will focus on taking measurements of hurricanes during the hurricanes, which hasn't been done before, according to Ruf.
"(Old satellites) stopped working well as soon as you get close to the middle of the hurricane because there is too much rain, and this new technique can see right through the rain well, so that's a big-deal thing," Ruf said.
Ruf added that studying such hard-to-reach areas of the storms can help meteorologists better forecast the intensity of hurricanes in the future.
Posselt said he joined the project to further investigate convection as a general topic, rather than solely tropical cyclones.
"My task on this is ... to explore uses of this data to try to understand tropical precipitation," Posselt said.
Posselt added that smaller storms are important to study as well.
"In the last five or 10 years or so, there's been a more concerted effort to try to understand these tropical systems, partly because they can give rise to hurricanes down the road if they persist long enough and organize in the right way," Posselt said.
Posselt added that NASA saw how their proposal would benefit science without an exorbitant cost.
"So for NASA, I think this probably fell in a bit of a sweet spot ... it's a measurement that we don't have globally but it's using technology that we don't have to spend tens of millions of dollars developing," Posselt said.
NASA spokesman Steve Cole said this mission will provide NASA with the kind of cutting-edge study of Earth they look for.
"NASA does a lot of research into developing for new ways to use the vantage point of space, having instruments in space to study weather, hurricanes, all sorts of earth science," Cole said. "We've had a number of missions that study winds ... and this mission is kind of pushing the envelope."
Cole added that it is somewhat unique for NASA to have a university-led mission.
"Most NASA missions are done not at universities, but we do have a history in a wide range of sciences of what we call P.I.-led missions. We have them in planet science and solar science," Cole said.