When one considers all the national and global crises that dominated the 2015 headlines, 2016 has the potential to be one of those landmark years that could change history.
In my lifetime, 1968 falls into that category. I vividly remember that at age 13, I tried to process the urban riots and the assassinations of Martin Luther King Jr. and Robert Kennedy. An emerging “women’s liberation” movement caught my interest, as I was trying to understand a new distrust of government called the “credibility gap.” But overall, it was the Vietnam War that dominated the nightly news. This was because in 1968 alone, 16,592 Americans were killed, making it the war’s deadliest year.
From my suburban-Boston teenage perspective, it appeared that our nation was not only at war in Southeast Asia but fighting against itself in cities and on college campuses.
Now, almost 48 years later, all the social, cultural, racial, global, and political upheavals that made 1968 the “year that changed everything” appear to be present again — only now on steroids — potent enough to make that tumultuous year look downright peaceful.
In 2015, everyone, almost simultaneously, became increasingly fed-up, ticked-off, offended, or outraged.
The reality of 2015 is that everyone, almost simultaneously, became increasingly fed-up, ticked-off, offended, or outraged about some personal, religious, ethnic, gender, economic, legal, global, environmental, political, media, hi-tech, sports, social, or GMO-food issue.
Atop all that is an intense national distrust in the federal government and an increasing disdain for its growth, cost, waste, and incompetence. Moreover, given that Americans are so polarized, the government always stands accused of doing either too much or too little — screwing up, whatever your major gripe or cause happens to be, viewed from the perspective of your political leanings.
In response to all this mayhem, we the people have opened our virtual windows and are yelling, “I’m mad as hell and I’m not going to take this anymore” — a flashback from the iconic 1976 movie Network — but with a new twist. Social media have become our new “window,” making it possible for us to rant and rave and show and tell everything to anyone, anywhere, at all times.
Since 2008, when then-senator Barack Obama campaigned on the slogan “Hope and Change” — and went on win the White House on a wave of feel-good bromides — we’ve witnessed a precipitous decline in national optimism and a rise in fear.
In 2016, if there is a contest for an official national slogan, my entry will be “Fear and Change.” Fear is reflected in a recent Quinnipiac poll that showed 83 percent of American voters believing that it is “very likely” or “somewhat likely” that a major terrorist attack will strike the U.S. in the near future.
Fear was also the driving force in a December 14 NBC/WSJ poll that prompted 40 percent of Americans to name “national security and terrorism” as the issue that they believe should be the federal government’s top priority. This knocked “job creation and economic growth” from the number-one spot, down to number two, at 23 percent. This was a huge shift from April, when jobs and growth were cited by 29 percent as the issue that Americans believed should be the government’s top priority.
Furthermore, this same NBC/WSJ poll found that only 20 percent of adults believe that our nation is headed in the right direction — compared with 70 percent who say it’s on the wrong track.
There is no doubt that negativity and fear have permeated our national psyche. Fear is fueled by the perception that our government is failing to keep us safe from terrorism and mass shootings. There is also the fear that we have lost our postwar global influence — with grave consequences yet to be realized. Perhaps the greatest long-term fear is the realization that America is rapidly changing for the worse. This is coupled with voters’ widely shared belief that they are powerless to prevent these negative changes.
Perhaps the greatest long-term fear is the realization that America is rapidly changing for the worse.
All of the above is the backdrop for what is guaranteed to be a traumatic 2016 at home and abroad, while a contentious presidential election takes center stage.
These fear-driven attitudes explain why businessman Donald Trump — whose slogan is “Make America Great Again” — is currently leading in the race for the Republican nomination. Most of his supporters strongly believe that he is America’s last great hope.
With a controversial candidate such as Trump, and an unpopular candidate like Hillary Clinton, the kind of social and political discontent that sparked the riots at the 1968 Democratic National Convention could return with new force in 2016, erupting at one or both of the summer’s national nominating conventions.
A major difference between 1968 and today, however, is that draft-age youth of that era were passionate, demanding an end to the Vietnam War. In 2016, fear of national decline and terrorism will be central issues, but they are not — yet — stirring up anywhere near as much passion. There is a distinct possibility, though, that the volatile issues of economic inequality, the growth of a large permanent underclass, and a demand for social justice and for criminal-justice reform among minority groups could explode at any time, creating massive national chaos.
In 2016, this we know for sure: No matter who is elected president, half the electorate will be convinced that our once-great nation is forever doomed.
But the risk of doom will be reduced if Hillary Clinton wins, because recently out on the campaign trail she said, “We’ve got to do everything we can to weed out hate and plant love and kindness.” Then, in a separate speech to African-American ministers, Clinton announced that she is running on a “love and kindness platform.”
This platform, along with her new campaign slogan “Love Trumps Hate,” channels that popular 1968 saying “Make Love, Not War.” Could this be Clinton’s secret strategy to defeat ISIS?
Our nation survived 1968, but 2016 is shaping up to be even more traumatic.
— Myra Adams is a media producer and political writer. She was on the 2004 Bush campaign’s creative team and the 2008 McCain campaign’s ad council. Her writing credits include the Washington Examiner, WorldNetDaily, PJ Media, the Daily Beast, RedState, and the Daily Caller. E-mail her at MyraAdams01@gmail.com. Follow her on Twitter @MyraKAdams.