Protecting Repayment of the EB-5 Investment: How to Navigate the Jungle of Intercreditor Loan Agreements
By Mike Gibson
EB-5 loans are often undertaken as subordinate loans. When in a subordinate position, an EB-5 lender should always consider whether it would be beneficial to request an intercreditor agreement from the senior lender in the transaction. If a lender’s and borrower’s negotiating power permits it, an intercreditor agreement could be a critical component in protecting the lender’s ability to repay EB-5 investors in a distressed project situation.
If the parties negotiating power does not support it, an intercreditor agreement can simply further erode a lender’s rights without any real benefits. Given that an intercreditor agreement can be a double-edged sword, a key early decision in a transaction is whether to require an intercreditor agreement as a lender, if one is not imposed by a senior lender in a transaction.
Identifying the Different Types of Loans
Before diving into the details of an intercreditor agreement, its important to understand the difference between a senior loan and a junior, mezzanine and subordinate loans, as these terms are often used interchangeably.
A senior loan is a loan secured in the first and highest priority position by collateral of the borrower, in the EB-5 context, the collateral is often real estate.
A junior loan is a loan secured by the same collateral as the senior loan but in a second or other junior position. A mezzanine loan is secured by a pledge of the ownership interests, like membership or partnership interests, of the real estate owner. The borrower is holder of such ownership interests and not the real property owner.
A subordinate loan, whether a junior loan or mezzanine loan, is secondary to the rights of the senior lender on a project. The key rights that could be subordinate are the right to realize on or sell any collateral held by the subordinate lienholder or the right to payment under the subordinate loan.
Each definition of the loans may have a nuance or altered meaning based on the specific terms and conditions of a transaction, however, the use of these terms means something to the average person that operates in the financial world and consistent use of these terms can avoid confusion regarding how a transaction is actually structured. In any of these structures, an intercreditor agreement should be considered by an EB-5 lender.
Key Points to Consider in a Negotiation
If you can obtain a reasonable intercreditor agreement, there are certain key points that every EB-5 lender should consider in that negotiation, which mostly relate to preserving control or economic rights over a project as long as possible. The key points in an intercreditor agreement for a subordinate lender are to preserve the ability to foreclose on collateral for the subordinate loan, preserve the ability to receive debt service payments, obtain the right to take over a defaulted project and complete construction and development, preserve recourse against guarantors and obtain the ability to purchase a senior loan if an event of default occurs.
Other key points include the ability to approve modifications of senior debt, in particular adverse changes in economic terms of the senior loan, and to have a standstill on the exercise of senior lender’s remedy of foreclosure for a limited period of time.
An additional benefit of being in a subordinate position is that the senior lender often will have the administrative infrastructure to monitor loan draws and the progress of construction of the project, thereby reducing the cost of the loan to the subordinate lender.
Even though intercreditor agreements are beneficial, not all key points will be achieved in every negotiation. There are some items that a subordinate lender might have to give up in an intercreditor agreement.
A subordinate lender will often be asked to give up the right to foreclose on subordinate collateral unless timely exercised, the right to repayment of subordinate debt if subordinate lender is unwilling or unable to cure defaults related to the project, the right to make independent decisions in a bankruptcy of the borrower, the right to pursue remedies against guarantors that are common guarantors with senior lender, the right to modify subordinate loan documents and the confirmation that EB-5 funds will be disbursed prior to senior loan funds.
So many rights of a subordinate lender are lost and key rights of the subordinate lender must be promptly and properly exercised or a borrower’s default can result in a total loss of an EB-5 investment in a project.
When an Agreement may be Beneficial
An intercreditor agreement can often take more than it can give a subordinate lender. Given that, unless the EB-5 lender or borrower have leverage to obtain a reasonable, arms-length negotiation of an intercreditor agreement, a subordinate lender will often be better suited to close a loan transaction without an intercreditor agreement. An EB-5 lender will have leverage in a transaction when its funds are critical to completion of a project or the lender has the independent economic means to complete a project.
A borrower will have leverage when it has a good, long-standing relationship with a senior lender or the ability to replace a senior lender with another party. A subordinate lender should consider these factors prior to even requesting an intercreditor agreement and after careful consideration, it could be a rational decision to proceed with a loan without requesting such an agreement.
The EB-5 loan has long conjured up an image of a covenant and compliance light loan structure on interest rate terms that are significantly more favorable than could otherwise be found in the marketplace for similar loans. The appeal to borrowers of such loans is understandable. However, the question was whether the regional center lenders and EB-5 investors were being properly protected in the prevailing EB-5 loan structures and documentation.
The evolution of EB-5 loans to more market loan structures and documentation terms is essential to the continued growth and viability of the EB-5 industry. Intercreditor agreements are a key part of that evolution. EB-5 investors are demanding loans and transactions that are structured on market terms and with market protections for their investment. Transactions that are structured solely as borrower-friendly vehicles without market protections for the EB-5 lenders and investors, will likely never find the investors needed to utilize EB-5 capital in a project.
EB-5 investors should not view intercreditor agreements as a requirement to a solidly structured EB-5 subordinate loan transaction but they absolutely should consider whether such an intercreditor agreement can be obtained on favorable terms in a subordinate loan structure.
(Editor’s Note: Chinese translations may vary slightly as published.)
Use a Facebook account to add a comment, subject to Facebook's Terms of Service and Privacy Policy. Your Facebook name, photo & other personal information you make public on Facebook will appear with your comment.