By Marieke Zoodsma -
On our way to Prijedor, one of the major cities in north-eastern Bosnia and Herzegovina, my host points out over the green, mountainous, and sunlit landscape and tells me: “Right over there behind those houses, they just found a new mass grave”. A couple of minutes later he explains that the men found in the grave are probably the men missing from the village up on the hill in front of us, since there are still so many unsolved cases. It is October 2013 and the International Commission for Missing Persons (ICMP) has just discovered one of the largest mass graves of the Bosnian war (1992-1995) nearby the small town of Tomašica, Bosnia and Herzegovina.
The mass grave had the size of a football field, measured some 10 meters deep, and would, according to officials, hold the remains of around 1,000 Bosniak and Croat men, women, and children – as several media outlets reported. Until now, 435 bodies have been recovered from the grave of which 284 have been identified and buried in July 2014. According to the numbers of the ICMP, from the 30,000 persons that were registered as missing person at the end of the Bosnian war, so far 22,000 persons have been accounted for. A large number of the remaining missing persons are from the region where this mass grave was found, the Krajina. The big and looming question that remains: how could it take 18 years for such a mass grave, a couple of hundred meters from local houses, to be found?
“The issue of missing persons can only be solved if the local community changes their attitude regarding the war crime that was committed” (Karčić 2013). The grave at Tomašica is located close to the border between the Republika Srpska and the Federation of Bosnia and Herzegovina, the two entities in which Bosnia and Herzegovina is split up after the signing of the Dayton Peace Agreements in 1995. During the war, Prijedor (which was to be included in the Republika Srpska) and its surroundings saw ethnic cleansing taking place on a massive scale – with as many as 52,000 non-Serbs being forcibly expelled from Prijedor’s total 120,000 pre-war residents. Three of the largest and most notorious concentration camps during the Bosnian war (Trnopolje, Omarska, and Keraterm) were located in the city’s vicinity. Professor Pettigrew (professor of Philosophy, Southern Connecticut State University) writes: “The mass graves are a testament to the genocide that was committed in Bosnia, as well as to the failure of the authorities of the Republika Srpska, as part of their genocide denial, to reveal their location”. Perhaps this must be seen as the most poignant explanation for the fact that not one individual living in the surroundings of Tomašica (and, for that matter, other mass graves) found it appropriate to notify local and international investigators about the existence of it. The three mutually exclusive narratives (that of the Bosnian Serbs, Bosnian Croats and Bosnian Muslims) about what happened during the war, who started it, and who is to blame, keep on being perpetuated in Bosnian society today. One of the key ingredients of the Bosnian Serb narrative is the denial of genocide in Bosnia and Herzegovina – hence the denial of the existence of mass graves since that would counter fact their story.
With the finding of mass graves and the uncovering of new facts, the search for truth is continued – often even revitalized. On December 13, 2014, local as well as international media reported that 15 Bosnian Serbs have been indicted for crimes against humanity over an attack on a village near Prijedor in 1992. During this attack, 150 Bosniak men, women, and children were killed and their bodies dumped in the Tomašica mass grave. Prosecutors at the International Criminal Tribunal for the former Yugoslavia (ICTY) have desperately tried to reopen their case after the Tomašica-site was found, especially the cases of the so-called ‘big fish’. For the trial against the former Bosnian Serb politician Radovan Karadžić it was too late. However in the case of Ratko Mladić, former Bosnian Serb military leader, new forensic evidence stemming from the mass grave has recently been tendered.
The challenges with the search for missing persons is not unique for Bosnia and Herzegovina. Forced disappearances are rife in conflicts and are often used as an explicit tactic of war. They wreak havoc on families and certain villages in Bosnia were left after the war without any male inhabitants. Besides the grief these families have to live through, such circumstances have high economic consequences for rural, patriarchal societies where the male is the main breadwinner. In the Bosnian film Snijeg (unfortunately only available online without subtitles) the ramifications of such a situation are vividly put to life on the big screen.
This year, 2015, the 20th commemoration of the ending of the Bosnian war will be held – the silence of those missing looming over the ceremonies. For the people in the small village up on that hill in north-eastern Bosnia and Herzegovina, that is what is happening now.
Further reading: An Appeal for Truth: The Human Rights Chamber and the Search for Missing Persons in Bosnia and Herzegovina, Hikmet Karčić (2013)
