/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Controller;

import com.hmdrinks.Service.ImgService;
import com.hmdrinks.Service.JwtService;
import com.hmdrinks.SupportFunction.SupportFunction;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@CrossOrigin
@RestController
@SecurityRequirement(name="bearerAuth")
@RequestMapping(value={"/api/image"})
public class ImageController {
    @Autowired
    private ImgService imgService;
    @Autowired
    private SupportFunction supportFunction;
    @Autowired
    private JwtService jwtService;

    @PostMapping(value={"/user/upload"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> handleUploadUserImage(@RequestParam(value="file") MultipartFile file, @RequestParam(value="userId") Integer id, HttpServletRequest httpRequest) throws IOException {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(id.intValue()));
        return ResponseEntity.ok((Object)this.imgService.uploadImgUser(file, id.intValue()));
    }

    @PostMapping(value={"/product/upload"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> handleUploadProductImage(@RequestParam(value="file") MultipartFile file, @RequestParam(value="proId") Integer id) throws IOException {
        return ResponseEntity.ok((Object)this.imgService.uploadImgProduct(file, id.intValue()));
    }

    @PostMapping(value={"/cate/upload"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> handleUploadCategoryImage(@RequestParam(value="file") MultipartFile file, @RequestParam(value="cateId") Integer id) throws IOException {
        return ResponseEntity.ok((Object)this.imgService.uploadImgCategory(file, id.intValue()));
    }

    @PostMapping(value={"/post/upload"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> handleUploadPostImage(@RequestParam(value="file") MultipartFile file, @RequestParam(value="cateId") Integer id) throws IOException {
        return ResponseEntity.ok((Object)this.imgService.uploadImgPost(file, id.intValue()));
    }
}

