/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Controller;

import com.hmdrinks.Request.CRUDProductReq;
import com.hmdrinks.Request.CreateProductReq;
import com.hmdrinks.Response.CRUDProductResponse;
import com.hmdrinks.Response.GetProductVariantFromProductIdResponse;
import com.hmdrinks.Response.ListProductResponse;
import com.hmdrinks.Service.ProductService;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@SecurityRequirement(name="bearerAuth")
@RequestMapping(value={"/api/product"})
public class ProductController {
    @Autowired
    private ProductService productService;

    @PostMapping(value={"/create"})
    public ResponseEntity<CRUDProductResponse> createAccount(@RequestBody CreateProductReq req) {
        return ResponseEntity.ok((Object)this.productService.crateProduct(req));
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<CRUDProductResponse> update(@RequestBody CRUDProductReq req) {
        return ResponseEntity.ok((Object)this.productService.updateProduct(req));
    }

    @GetMapping(value={"/view/{id}"})
    public ResponseEntity<CRUDProductResponse> update(@PathVariable Integer id) {
        return ResponseEntity.ok((Object)this.productService.getOneProduct(id));
    }

    @GetMapping(value={"/list-product"})
    public ResponseEntity<ListProductResponse> listAllUser() {
        return ResponseEntity.ok((Object)this.productService.listProduct());
    }

    @GetMapping(value={"/variants/{id}"})
    public ResponseEntity<GetProductVariantFromProductIdResponse> viewProduct(@PathVariable Integer id) {
        return ResponseEntity.ok((Object)this.productService.getAllProductVariantFromProduct(id.intValue()));
    }
}

