/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import com.hmdrinks.Entity.User;
import com.hmdrinks.Enum.Sex;
import com.hmdrinks.Enum.TypeLogin;
import com.hmdrinks.Exception.BadRequestException;
import com.hmdrinks.Exception.ConflictException;
import com.hmdrinks.Repository.UserRepository;
import com.hmdrinks.Request.CreateAccountUserReq;
import com.hmdrinks.Response.CRUDAccountUserResponse;
import com.hmdrinks.SupportFunction.SupportFunction;
import java.time.LocalDate;
import java.util.Date;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AdminService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private SupportFunction supportFunction;
    @Autowired
    PasswordEncoder passwordEncoder;

    public CRUDAccountUserResponse createAccountUser(CreateAccountUserReq req) {
        Optional user = this.userRepository.findByUserNameAndIsDeletedFalse(req.getUserName());
        if (user.isPresent()) {
            throw new ConflictException("User name already exists");
        }
        if (!this.supportFunction.checkRole(req.getRole().toString())) {
            throw new BadRequestException("Role is wrong");
        }
        User userWithEmail = this.userRepository.findByEmail(req.getEmail());
        if (userWithEmail != null && userWithEmail.getUserName() != req.getUserName()) {
            throw new ConflictException("Email already exists with another user");
        }
        LocalDate currentDate = LocalDate.now();
        User user1 = new User();
        user1.setType(TypeLogin.BASIC);
        user1.setEmail(req.getEmail());
        user1.setRole(req.getRole());
        user1.setIsDeleted(Boolean.valueOf(false));
        user1.setUserName(req.getUserName());
        user1.setAvatar("");
        user1.setDistrict("");
        user1.setCity("");
        user1.setStreet("");
        user1.setSex(Sex.OTHER);
        user1.setDateCreated((Date)java.sql.Date.valueOf(currentDate));
        user1.setPhoneNumber("");
        user1.setPassword(this.passwordEncoder.encode((CharSequence)req.getPassword()));
        user1.setFullName(req.getFullName());
        this.userRepository.save((Object)user1);
        Optional userNewq = this.userRepository.findByUserNameAndIsDeletedFalse(req.getUserName());
        User userNew = (User)userNewq.get();
        return new CRUDAccountUserResponse(userNew.getUserId(), userNew.getUserName(), userNew.getFullName(), userNew.getAvatar(), userNew.getBirthDate(), "", userNew.getEmail(), userNew.getPhoneNumber(), userNew.getSex().toString(), userNew.getType().toString(), userNew.getIsDeleted(), userNew.getDateDeleted(), userNew.getDateUpdated(), userNew.getDateCreated(), userNew.getRole().toString());
    }
}

