/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import com.hmdrinks.Entity.Post;
import com.hmdrinks.Entity.User;
import com.hmdrinks.Enum.Role;
import com.hmdrinks.Repository.PostRepository;
import com.hmdrinks.Repository.UserRepository;
import com.hmdrinks.Request.CRUDPostReq;
import com.hmdrinks.Request.CreateNewPostReq;
import com.hmdrinks.Response.CRUDPostResponse;
import com.hmdrinks.Response.ListAllPostByUserIdResponse;
import com.hmdrinks.Response.ListAllPostResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostService {
    @Autowired
    private PostRepository postRepository;
    @Autowired
    private UserRepository userRepository;

    public CRUDPostResponse createPost(CreateNewPostReq req) {
        User user = this.userRepository.findByUserId(req.getUserId());
        if (user == null) {
            throw new RuntimeException("Not found user");
        }
        if (user.getRole() != Role.ADMIN) {
            throw new RuntimeException("Not allowed to add post");
        }
        Date currentDate = new Date();
        Post post = new Post();
        post.setTitle(req.getTitle());
        post.setDescription(req.getDescription());
        post.setUser(user);
        post.setBannerUrl(req.getUrl());
        post.setShortDes(req.getShortDescription());
        post.setIsDeleted(Boolean.valueOf(false));
        post.setDateCreate(currentDate);
        this.postRepository.save((Object)post);
        return new CRUDPostResponse(post.getPostId().intValue(), post.getBannerUrl(), post.getDescription(), post.getTitle(), post.getShortDes(), post.getUser().getUserId(), post.getIsDeleted(), post.getDateDeleted(), post.getDateCreate());
    }

    public CRUDPostResponse getPostById(int postId) {
        Post post = this.postRepository.findByPostId(postId);
        if (post == null) {
            throw new RuntimeException("Not found post");
        }
        return new CRUDPostResponse(post.getPostId().intValue(), post.getBannerUrl(), post.getDescription(), post.getTitle(), post.getShortDes(), post.getUser().getUserId(), post.getIsDeleted(), post.getDateDeleted(), post.getDateCreate());
    }

    public CRUDPostResponse updatePost(CRUDPostReq req) {
        Post post = this.postRepository.findByPostId(req.getPostId());
        if (post == null) {
            throw new RuntimeException("Not found post");
        }
        User user = this.userRepository.findByUserId(req.getUserId());
        if (user == null) {
            throw new RuntimeException("Not found user");
        }
        if (user.getRole() != Role.ADMIN) {
            throw new RuntimeException("Not allowed to add post");
        }
        post.setTitle(req.getTitle());
        post.setDescription(req.getDescription());
        post.setShortDes(req.getShortDescription());
        post.setBannerUrl(req.getUrl());
        this.postRepository.save((Object)post);
        return new CRUDPostResponse(post.getPostId().intValue(), post.getBannerUrl(), post.getDescription(), post.getTitle(), post.getShortDes(), post.getUser().getUserId(), post.getIsDeleted(), post.getDateDeleted(), post.getDateCreate());
    }

    public ListAllPostResponse getAllPost() {
        List posts = this.postRepository.findAll();
        ArrayList<CRUDPostResponse> responses = new ArrayList<CRUDPostResponse>();
        for (Post post : posts) {
            responses.add(new CRUDPostResponse(post.getPostId().intValue(), post.getBannerUrl(), post.getDescription(), post.getTitle(), post.getShortDes(), post.getUser().getUserId(), post.getIsDeleted(), post.getDateDeleted(), post.getDateCreate()));
        }
        return new ListAllPostResponse(responses);
    }

    public ListAllPostByUserIdResponse listAllPostByUserId(int userId) {
        User user = this.userRepository.findByUserId(userId);
        if (user == null) {
            throw new RuntimeException("Not found user");
        }
        List posts = this.postRepository.findByUserUserId(Integer.valueOf(userId));
        ArrayList<CRUDPostResponse> responses = new ArrayList<CRUDPostResponse>();
        for (Post post : posts) {
            responses.add(new CRUDPostResponse(post.getPostId().intValue(), post.getBannerUrl(), post.getDescription(), post.getTitle(), post.getShortDes(), post.getUser().getUserId(), post.getIsDeleted(), post.getDateDeleted(), post.getDateCreate()));
        }
        return new ListAllPostByUserIdResponse(userId, responses);
    }
}

