/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Controller;

import com.hmdrinks.Request.LoginBasicReq;
import com.hmdrinks.Request.UserCreateReq;
import com.hmdrinks.Response.AuthenticationResponse;
import com.hmdrinks.Service.AuthenticationService;
import com.hmdrinks.Service.UserService;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@SecurityRequirement(name="bearerAuth")
@RequestMapping(value={"/api/v1/auth"})
public class AuthenticationController {
    @Autowired
    private UserService userService;
    @Autowired
    private AuthenticationService authenticationService;

    @PostMapping(value={"/authenticate"})
    public ResponseEntity<AuthenticationResponse> authenticate(@RequestBody LoginBasicReq request) {
        return ResponseEntity.ok((Object)this.authenticationService.authenticate(request));
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<AuthenticationResponse> register(@RequestBody UserCreateReq req) {
        return ResponseEntity.ok((Object)this.authenticationService.register(req));
    }

    @PostMapping(value={"/refresh-token"})
    public ResponseEntity<AuthenticationResponse> refreshToken(HttpServletRequest request, HttpServletResponse response) {
        return ResponseEntity.ok((Object)this.authenticationService.refreshToken(request, response));
    }
}

