/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import com.hmdrinks.Entity.Cart;
import com.hmdrinks.Entity.CartItem;
import com.hmdrinks.Entity.Product;
import com.hmdrinks.Entity.ProductVariants;
import com.hmdrinks.Entity.User;
import com.hmdrinks.Enum.Status_Cart;
import com.hmdrinks.Exception.BadRequestException;
import com.hmdrinks.Repository.CartItemRepository;
import com.hmdrinks.Repository.CartRepository;
import com.hmdrinks.Repository.ProductRepository;
import com.hmdrinks.Repository.ProductVariantsRepository;
import com.hmdrinks.Repository.UserRepository;
import com.hmdrinks.Request.DeleteAllCartItemReq;
import com.hmdrinks.Request.DeleteOneCartItemReq;
import com.hmdrinks.Request.IncreaseDecreaseItemQuantityReq;
import com.hmdrinks.Request.InsertItemToCart;
import com.hmdrinks.Response.CRUDCartItemResponse;
import com.hmdrinks.Response.DeleteCartItemResponse;
import com.hmdrinks.Response.IncreaseDecreaseItemQuantityResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CartItemService {
    @Autowired
    private CartItemRepository cartItemRepository;
    @Autowired
    private ProductVariantsRepository productVariantsRepository;
    @Autowired
    private ProductRepository productRepository;
    @Autowired
    private CartRepository cartRepository;
    @Autowired
    private UserRepository userRepository;

    public CRUDCartItemResponse insertCartItem(InsertItemToCart req) {
        User user = this.userRepository.findByUserId(req.getUserId());
        if (user == null) {
            throw new BadRequestException("Not found user");
        }
        Product product = this.productRepository.findByProId(Integer.valueOf(req.getProId()));
        if (product == null) {
            throw new BadRequestException("proId not exists");
        }
        ProductVariants productVariants = this.productVariantsRepository.findBySizeAndProduct_ProId(req.getSize(), Integer.valueOf(req.getProId()));
        if (productVariants == null) {
            throw new BadRequestException("production size not exists");
        }
        Cart cart1 = this.cartRepository.findByUserUserIdAndStatus(user.getUserId(), Status_Cart.NEW);
        if (cart1 == null) {
            throw new BadRequestException("Cart for userId not exists");
        }
        Cart cart = this.cartRepository.findByCartId(req.getCartId());
        if (cart == null) {
            throw new BadRequestException("Not found cart");
        }
        if (req.getQuantity() < 0) {
            throw new BadRequestException("quantity must larger 0");
        }
        CartItem cartItem1 = this.cartItemRepository.findByProductVariants_VarIdAndProductVariants_SizeAndCart_CartId(Integer.valueOf(productVariants.getVarId()), req.getSize(), Integer.valueOf(req.getCartId()));
        CartItem cartItem = new CartItem();
        if (cartItem1 == null) {
            if (req.getQuantity() > productVariants.getStock()) {
                throw new BadRequestException("h\u1ebft h\u00e0ng r\u1ed3i hmm");
            }
            Double totalPrice = (double)req.getQuantity() * productVariants.getPrice();
            Integer stock_quantity = productVariants.getStock() - req.getQuantity();
            cartItem.setCart(cart);
            cartItem.setQuantity(req.getQuantity());
            cartItem.setProductVariants(productVariants);
            cartItem.setTotalPrice(totalPrice.doubleValue());
            this.cartItemRepository.save((Object)cartItem);
            List cartItemList = this.cartItemRepository.findByCart_CartId(Integer.valueOf(req.getCartId()));
            Double Price = 0.0;
            Integer Quantity = 0;
            for (CartItem cartItem2 : cartItemList) {
                Price = Price + Double.valueOf(cartItem2.getTotalPrice());
                Quantity = Quantity + cartItem2.getQuantity();
            }
            cart.setTotalProduct(Quantity.intValue());
            cart.setTotalPrice(Price.doubleValue());
            this.cartRepository.save((Object)cart);
            return new CRUDCartItemResponse(cartItem.getCartItemId(), cartItem.getProductVariants().getProduct().getProId(), cartItem.getCart().getCartId(), cartItem.getProductVariants().getSize(), cartItem.getTotalPrice(), cartItem.getQuantity());
        }
        if (req.getQuantity() + cartItem1.getQuantity() > productVariants.getStock()) {
            throw new BadRequestException("h\u1ebft h\u00e0ng r\u1ed3i hmm");
        }
        Integer stock_quantity = productVariants.getStock() - req.getQuantity();
        Double totalPrice = (double)(req.getQuantity() + cartItem1.getQuantity()) * productVariants.getPrice();
        cartItem1.setTotalPrice(totalPrice.doubleValue());
        cartItem1.setQuantity(req.getQuantity() + cartItem1.getQuantity());
        this.cartItemRepository.save((Object)cartItem1);
        List cartItemList = this.cartItemRepository.findByCart_CartId(Integer.valueOf(req.getCartId()));
        Double Price = 0.0;
        Integer Quantity = 0;
        for (CartItem cartItem2 : cartItemList) {
            Price = Price + Double.valueOf(cartItem2.getTotalPrice());
            Quantity = Quantity + cartItem2.getQuantity();
        }
        cart.setTotalProduct(Quantity.intValue());
        cart.setTotalPrice(Price.doubleValue());
        this.cartRepository.save((Object)cart);
        return new CRUDCartItemResponse(cartItem1.getCartItemId(), cartItem1.getProductVariants().getProduct().getProId(), cartItem1.getCart().getCartId(), cartItem1.getProductVariants().getSize(), cartItem1.getTotalPrice(), cartItem1.getQuantity());
    }

    public IncreaseDecreaseItemQuantityResponse increaseCartItemQuantity(IncreaseDecreaseItemQuantityReq req) {
        CartItem cartItem = this.cartItemRepository.findByCartItemId(req.getCartItemId());
        if (cartItem == null) {
            throw new BadRequestException("Not found cartItem");
        }
        if (req.getQuantity() < 0) {
            throw new BadRequestException("quantity must larger 0");
        }
        ProductVariants productVariants = this.productVariantsRepository.findByVarId(Integer.valueOf(cartItem.getProductVariants().getProduct().getProId()));
        Integer Present_Quantity = cartItem.getQuantity() + 1;
        if (req.getQuantity() + 1 > productVariants.getStock()) {
            throw new BadRequestException("h\u1ebft h\u00e0ng r\u1ed3i l\u00ec nh\u01b0 tr\u00e2u ");
        }
        cartItem.setQuantity(Present_Quantity.intValue());
        this.cartItemRepository.save((Object)cartItem);
        Cart cart = this.cartRepository.findByCartId(cartItem.getCart().getCartId());
        if (cart == null) {
            throw new BadRequestException("Not found cart");
        }
        List cartItemList = this.cartItemRepository.findByCart_CartId(Integer.valueOf(cartItem.getCart().getCartId()));
        Double Price = 0.0;
        Integer Quantity = 0;
        for (CartItem cartItem2 : cartItemList) {
            Price = Price + Double.valueOf(cartItem2.getTotalPrice());
            Quantity = Quantity + cartItem2.getQuantity();
        }
        cart.setTotalProduct(Quantity.intValue());
        cart.setTotalPrice(Price.doubleValue());
        this.cartRepository.save((Object)cart);
        return new IncreaseDecreaseItemQuantityResponse(Present_Quantity.intValue());
    }

    public IncreaseDecreaseItemQuantityResponse decreaseCartItemQuantity(IncreaseDecreaseItemQuantityReq req) {
        CartItem cartItem = this.cartItemRepository.findByCartItemId(req.getCartItemId());
        if (cartItem == null) {
            throw new BadRequestException("Not found cartItem");
        }
        if (req.getQuantity() < 0) {
            throw new BadRequestException("quantity must larger 0");
        }
        ProductVariants productVariants = this.productVariantsRepository.findByVarId(Integer.valueOf(cartItem.getProductVariants().getVarId()));
        int Present_Quantity = cartItem.getQuantity() - 1;
        System.out.println(productVariants.getStock());
        if (req.getQuantity() - 1 > productVariants.getStock()) {
            throw new BadRequestException("h\u1ebft h\u00e0ng r\u1ed3i hmm");
        }
        cartItem.setQuantity(Present_Quantity);
        this.cartItemRepository.save((Object)cartItem);
        Cart cart = this.cartRepository.findByCartId(cartItem.getCart().getCartId());
        if (cart == null) {
            throw new BadRequestException("Not found cart");
        }
        List cartItemList = this.cartItemRepository.findByCart_CartId(Integer.valueOf(cartItem.getCart().getCartId()));
        Double Price = 0.0;
        Integer Quantity = 0;
        for (CartItem cartItem2 : cartItemList) {
            Price = Price + Double.valueOf(cartItem2.getTotalPrice());
            Quantity = Quantity + cartItem2.getQuantity();
        }
        cart.setTotalProduct(Quantity.intValue());
        cart.setTotalPrice(Price.doubleValue());
        this.cartRepository.save((Object)cart);
        return new IncreaseDecreaseItemQuantityResponse(Present_Quantity);
    }

    public DeleteCartItemResponse deleteOneItem(DeleteOneCartItemReq req) {
        CartItem cartItem = this.cartItemRepository.findByCartItemId(req.getCartItemId());
        if (cartItem == null) {
            throw new BadRequestException("Not found cartItem");
        }
        this.cartItemRepository.delete((Object)cartItem);
        List cartItemList = this.cartItemRepository.findByCart_CartId(Integer.valueOf(cartItem.getCart().getCartId()));
        Double Price = 0.0;
        Integer Quantity = 0;
        for (CartItem cartItem2 : cartItemList) {
            Price = Price + Double.valueOf(cartItem2.getTotalPrice());
            Quantity = Quantity + cartItem2.getQuantity();
        }
        Cart cart = this.cartRepository.findByCartId(cartItem.getCart().getCartId());
        cart.setTotalProduct(Quantity.intValue());
        cart.setTotalPrice(Price.doubleValue());
        this.cartRepository.save((Object)cart);
        return new DeleteCartItemResponse("Delete item success");
    }

    public DeleteCartItemResponse deleteAllCartItem(DeleteAllCartItemReq req) {
        Cart cart = this.cartRepository.findByCartIdAndStatus(req.getCartId(), Status_Cart.NEW);
        if (cart == null) {
            throw new BadRequestException("Not found cart");
        }
        List cartItemList = this.cartItemRepository.findByCart_CartId(Integer.valueOf(req.getCartId()));
        for (CartItem cartItem2 : cartItemList) {
            this.cartItemRepository.delete((Object)cartItem2);
        }
        cart.setTotalProduct(0);
        cart.setTotalPrice(0.0);
        this.cartRepository.save((Object)cart);
        return new DeleteCartItemResponse("Delete all item success");
    }
}

