/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClaims;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class JwtService {
    @Value(value="${application.security.jwt.secret-key}")
    private String secretKey;
    @Value(value="${application.security.jwt.expiration}")
    private long jwtExpiration;
    @Value(value="${application.security.jwt.refresh-token.expiration}")
    private long refreshExpiration;

    public String extractUsername(String token) {
        return (String)this.extractClaim(token, Claims::getSubject);
    }

    public String extractUserId(String token) {
        return (String)this.extractNotCheckingClaim(token, claims -> (String)claims.get("UserId", String.class));
    }

    public Date extractCreateDate(String token) {
        return (Date)this.extractNotCheckingClaim(token, Claims::getIssuedAt);
    }

    public <T> T extractNotCheckingClaim(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.extractNotCheckingClaims(token);
        return claimsResolver.apply(claims);
    }

    public <T> T extractClaim(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.extractAllClaims(token);
        return claimsResolver.apply(claims);
    }

    public String generateToken(UserDetails userDetails, String userId, String roles) {
        return this.generateToken(new HashMap(), userDetails, userId, roles);
    }

    public String generateToken(Map<String, Object> extraClaims, UserDetails userDetails, String userId, String roles) {
        return this.buildToken(extraClaims, userDetails, this.jwtExpiration, userId, roles);
    }

    public String generateRefreshToken(UserDetails userDetails, String userId, String role) {
        return this.buildToken(new HashMap(), userDetails, this.refreshExpiration, userId, role);
    }

    private String buildToken(Map<String, Object> extraClaims, UserDetails userDetails, long expiration, String userId, String roles) {
        extraClaims.put("Roles", roles);
        extraClaims.put("UserId", userId);
        return Jwts.builder().setClaims(extraClaims).setSubject(userDetails.getUsername()).setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + expiration)).signWith(this.getSignInKey(), SignatureAlgorithm.HS256).compact();
    }

    public boolean isTokenValid(String token, UserDetails userDetails) {
        String username = this.extractUsername(token);
        return username.equals(userDetails.getUsername()) && !this.isTokenExpired(token);
    }

    private boolean isTokenExpired(String token) {
        return this.extractExpiration(token).before(new Date());
    }

    private Date extractExpiration(String token) {
        return (Date)this.extractClaim(token, Claims::getExpiration);
    }

    private Claims extractAllClaims(String token) {
        return (Claims)Jwts.parserBuilder().setSigningKey(this.getSignInKey()).build().parseClaimsJws(token).getBody();
    }

    private Claims extractNotCheckingClaims(String token) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(this.getSignInKey()).parseClaimsJws(token).getBody();
            return claims;
        }
        catch (ExpiredJwtException ex) {
            DefaultClaims claims = (DefaultClaims)ex.getClaims();
            return claims;
        }
    }

    private Key getSignInKey() {
        byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)this.secretKey);
        return Keys.hmacShaKeyFor((byte[])keyBytes);
    }
}

