/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Service;

import com.hmdrinks.Entity.Post;
import com.hmdrinks.Entity.Voucher;
import com.hmdrinks.Enum.Status_Voucher;
import com.hmdrinks.Exception.BadRequestException;
import com.hmdrinks.Repository.PostRepository;
import com.hmdrinks.Repository.VoucherRepository;
import com.hmdrinks.Request.CreateVoucherReq;
import com.hmdrinks.Request.CrudVoucherReq;
import com.hmdrinks.Response.CRUDVoucherResponse;
import com.hmdrinks.Response.ListAllVoucherResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherService {
    @Autowired
    private VoucherRepository voucherRepository;
    @Autowired
    private PostRepository postRepository;

    public CRUDVoucherResponse createVoucher(CreateVoucherReq req) {
        Post post = this.postRepository.findByPostId(req.getPostId());
        if (post == null) {
            throw new BadRequestException("Not found post");
        }
        Voucher vou = this.voucherRepository.findByPostPostId(req.getPostId());
        if (vou != null) {
            throw new BadRequestException("Voucher Post already exists");
        }
        Date createPost = post.getDateCreate();
        Date currentDate = new Date();
        if (req.getStartDate().before(currentDate)) {
            throw new BadRequestException("Start date must be greater than or equal to current date");
        }
        if (req.getEndDate().before(createPost) || req.getEndDate().before(currentDate)) {
            throw new BadRequestException("End date must be greater than start date and current date");
        }
        if (req.getStartDate().before(createPost)) {
            throw new BadRequestException("Start date must be greater than or equal to post creation date");
        }
        if (req.getEndDate().before(createPost)) {
            throw new BadRequestException("End date must be greater than or equal to post creation date");
        }
        Voucher voucher = new Voucher();
        voucher.setPost(post);
        voucher.setStartDate(req.getStartDate());
        voucher.setEndDate(req.getEndDate());
        voucher.setIsDeleted(Boolean.valueOf(false));
        voucher.setDiscount(req.getDiscount());
        voucher.setStatus(Status_Voucher.ACTIVE);
        this.voucherRepository.save((Object)voucher);
        return new CRUDVoucherResponse(voucher.getVoucherId().intValue(), voucher.getStartDate(), voucher.getEndDate(), voucher.getDiscount(), voucher.getStatus(), voucher.getPost().getPostId().intValue());
    }

    public CRUDVoucherResponse updateVoucher(CrudVoucherReq req) {
        Voucher voucher = this.voucherRepository.findByVoucherId(req.getVoucherId());
        if (voucher == null) {
            throw new BadRequestException("Not found voucher");
        }
        if (voucher.getPost().getPostId().intValue() == req.getVoucherId()) {
            Post post = this.postRepository.findByPostId(voucher.getPost().getPostId().intValue());
            if (post == null) {
                throw new BadRequestException("Not found post");
            }
            Date createPost = post.getDateCreate();
            Date currentDate = new Date();
            if (req.getStartDate().before(currentDate)) {
                throw new BadRequestException("Start date must be greater than or equal to current date");
            }
            if (req.getEndDate().before(createPost) || req.getEndDate().before(currentDate)) {
                throw new BadRequestException("End date must be greater than start date and current date");
            }
            if (req.getStartDate().before(createPost)) {
                throw new BadRequestException("Start date must be greater than or equal to post creation date");
            }
            if (req.getEndDate().before(createPost)) {
                throw new BadRequestException("End date must be greater than or equal to post creation date");
            }
            voucher.setPost(post);
            voucher.setStartDate(req.getStartDate());
            voucher.setEndDate(req.getEndDate());
            voucher.setDiscount(req.getDiscount());
            return new CRUDVoucherResponse(voucher.getVoucherId().intValue(), voucher.getStartDate(), voucher.getEndDate(), voucher.getDiscount(), voucher.getStatus(), voucher.getPost().getPostId().intValue());
        }
        Voucher vou = this.voucherRepository.findByPostPostId(req.getPostId());
        if (vou != null) {
            throw new BadRequestException("Voucher Post already exists");
        }
        Post post = this.postRepository.findByPostId(req.getPostId());
        if (post == null) {
            throw new BadRequestException("Not found post");
        }
        Date createPost = post.getDateCreate();
        Date currentDate = new Date();
        if (req.getStartDate().before(currentDate)) {
            throw new BadRequestException("Start date must be greater than or equal to current date");
        }
        if (req.getEndDate().before(createPost) || req.getEndDate().before(currentDate)) {
            throw new BadRequestException("End date must be greater than start date and current date");
        }
        if (req.getStartDate().before(createPost)) {
            throw new BadRequestException("Start date must be greater than or equal to post creation date");
        }
        if (req.getEndDate().before(createPost)) {
            throw new BadRequestException("End date must be greater than or equal to post creation date");
        }
        voucher.setPost(post);
        voucher.setStartDate(req.getStartDate());
        voucher.setEndDate(req.getEndDate());
        voucher.setDiscount(req.getDiscount());
        return new CRUDVoucherResponse(voucher.getVoucherId().intValue(), voucher.getStartDate(), voucher.getEndDate(), voucher.getDiscount(), voucher.getStatus(), voucher.getPost().getPostId().intValue());
    }

    public CRUDVoucherResponse getVoucherById(int voucherId) {
        Voucher voucher = this.voucherRepository.findByVoucherId(voucherId);
        if (voucher == null) {
            throw new BadRequestException("Not found voucher");
        }
        return new CRUDVoucherResponse(voucher.getVoucherId().intValue(), voucher.getStartDate(), voucher.getEndDate(), voucher.getDiscount(), voucher.getStatus(), voucher.getPost().getPostId().intValue());
    }

    public ListAllVoucherResponse listAllVoucher() {
        List voucherList = this.voucherRepository.findAll();
        ArrayList<CRUDVoucherResponse> crudVoucherResponses = new ArrayList<CRUDVoucherResponse>();
        for (Voucher voucher : voucherList) {
            crudVoucherResponses.add(new CRUDVoucherResponse(voucher.getVoucherId().intValue(), voucher.getStartDate(), voucher.getEndDate(), voucher.getDiscount(), voucher.getStatus(), voucher.getPost().getPostId().intValue()));
        }
        return new ListAllVoucherResponse(crudVoucherResponses);
    }
}

