/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Config;

import com.hmdrinks.Repository.TokenRepository;
import com.hmdrinks.Service.JwtService;
import com.hmdrinks.Service.UserInfoService;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.SignatureException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import lombok.NonNull;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    private final JwtService jwtService;
    private final UserInfoService myUserDetailsService;
    private final TokenRepository tokenRepository;

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (filterChain == null) {
            throw new NullPointerException("filterChain is marked non-null but is null");
        }
        if (request.getServletPath().contains("/api/v1/auth")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String authHeader = request.getHeader("Authorization");
        String userEmail = null;
        if (authHeader == null || !authHeader.startsWith("Bearer ")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String jwt = authHeader.substring(7);
        String msg = new String();
        try {
            userEmail = this.jwtService.extractUsername(jwt);
        }
        catch (SignatureException ex) {
            msg = "Invalid JWT signature";
        }
        catch (MalformedJwtException ex) {
            msg = "Invalid JWT token";
        }
        catch (ExpiredJwtException ex) {
            msg = "Expired JWT token";
        }
        catch (UnsupportedJwtException ex) {
            msg = "Unsupported JWT token";
        }
        catch (IllegalArgumentException ex) {
            msg = "JWT claims string is empty.";
        }
        if (userEmail != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            UserDetails userDetails = null;
            try {
                userDetails = this.myUserDetailsService.loadUserByUsername(userEmail);
            }
            catch (UsernameNotFoundException ex) {
                msg = "JWT token not exist";
            }
            if (userDetails != null) {
                Boolean isTokenValid = this.tokenRepository.findByAccessToken(jwt).map(t -> {
                    Date expiredDateTime = t.getExpire();
                    Instant expiredInstant = expiredDateTime.toInstant();
                    Instant extendedExpiryTime = expiredInstant.plusSeconds(90000000L);
                    Instant now = Instant.now();
                    return now.isBefore(extendedExpiryTime);
                }).orElse(false);
                if (this.jwtService.isTokenValid(jwt, userDetails) && isTokenValid.booleanValue()) {
                    UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                    authToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
                } else {
                    msg = "JWT token is not found";
                }
            }
        }
        if (!msg.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("{ ");
            sb.append("\"error\": \"Unauthorized\",");
            sb.append("\"message\": \"" + msg + "\",");
            sb.append("\"path\": \"").append(request.getRequestURL()).append("\"");
            sb.append("} ");
            response.setContentType("application/json");
            response.setStatus(401);
            response.getWriter().write(sb.toString());
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public JwtAuthenticationFilter(JwtService jwtService, UserInfoService myUserDetailsService, TokenRepository tokenRepository) {
        this.jwtService = jwtService;
        this.myUserDetailsService = myUserDetailsService;
        this.tokenRepository = tokenRepository;
    }
}

