/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Config;

import com.hmdrinks.Config.JwtAuthenticationFilter;
import com.hmdrinks.Config.MyAccessDeniedHandler;
import com.hmdrinks.Service.LogoutService;
import jakarta.servlet.Filter;
import java.util.Arrays;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
public class SecurityConfig {
    private final AuthenticationProvider authenticationProvider;
    private final JwtAuthenticationFilter jwtAuthFilter;
    private final MyAccessDeniedHandler myAccessDeniedHandler;
    private final LogoutService logoutService;

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.cors(Customizer.withDefaults()).csrf(csrf -> csrf.disable()).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/v2/api-docs", "/v3/api-docs", "/v3/api-docs/**", "/swagger-resources", "/swagger-resources/**", "/configuration/ui", "/configuration/security", "/swagger-ui/**", "/swagger-ui.html"})).permitAll().requestMatchers(new String[]{"/api/v1/auth/authenticate", "/api/v1/auth/register"})).permitAll().requestMatchers(new String[]{"/api/product/view/**", "/api/product/list-product", "/api/product/variants/**"})).permitAll().requestMatchers(new String[]{"/api/cate/view/**", "/api/cate/list-category"})).permitAll().requestMatchers(new String[]{"/api/post/view/**"})).permitAll().requestMatchers(new String[]{"/api/voucher/view/**"})).permitAll().requestMatchers(new String[]{"/api/user-voucher/view-all/**"})).permitAll().requestMatchers(new String[]{"/api/user-voucher/**"})).hasAnyAuthority(new String[]{"ADMIN", "CUSTOMER", "SHIPPER"}).requestMatchers(new String[]{"/api/admin/**"})).hasAuthority("ADMIN").requestMatchers(new String[]{"/api/user/**"})).hasAnyAuthority(new String[]{"ADMIN", "CUSTOMER"}).requestMatchers(new String[]{"/api/image/user/**"})).hasAnyAuthority(new String[]{"ADMIN", "CUSTOMER"}).requestMatchers(new String[]{"/api/image/**"})).hasAnyAuthority(new String[]{"ADMIN"}).requestMatchers(new String[]{"/api/cate/**"})).hasAuthority("ADMIN").requestMatchers(new String[]{"/api/product/**"})).hasAnyAuthority(new String[]{"ADMIN"}).requestMatchers(new String[]{"/api/voucher/**"})).hasAuthority("ADMIN").requestMatchers(new String[]{"/api/post/**"})).hasAnyAuthority(new String[]{"ADMIN"}).requestMatchers(new String[]{"/api/productVar/**"})).hasAuthority("ADMIN").requestMatchers(new String[]{"/api/cart/**"})).hasAnyAuthority(new String[]{"ADMIN", "CUSTOMER", "SHIPPER"}).requestMatchers(new String[]{"/api/cart-item/**"})).hasAnyAuthority(new String[]{"ADMIN", "CUSTOMER", "SHIPPER"}).requestMatchers(new String[]{"/api/public/**"})).permitAll().anyRequest()).authenticated()).exceptionHandling(exception -> exception.accessDeniedHandler((AccessDeniedHandler)this.myAccessDeniedHandler)).sessionManagement(sess -> sess.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authenticationProvider(this.authenticationProvider).addFilterBefore((Filter)this.jwtAuthFilter, UsernamePasswordAuthenticationFilter.class).logout(logout -> logout.logoutUrl("/api/v1/auth/logout").addLogoutHandler((LogoutHandler)this.logoutService).logoutSuccessHandler((request, response, authentication) -> SecurityContextHolder.clearContext()));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowedOrigins(Arrays.asList("*"));
        corsConfiguration.setAllowedMethods(Arrays.asList("GET", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"));
        corsConfiguration.setAllowedHeaders(Arrays.asList("Authorization", "content-type"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", corsConfiguration);
        return source;
    }

    public SecurityConfig(AuthenticationProvider authenticationProvider, JwtAuthenticationFilter jwtAuthFilter, MyAccessDeniedHandler myAccessDeniedHandler, LogoutService logoutService) {
        this.authenticationProvider = authenticationProvider;
        this.jwtAuthFilter = jwtAuthFilter;
        this.myAccessDeniedHandler = myAccessDeniedHandler;
        this.logoutService = logoutService;
    }
}

