/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Controller;

import com.hmdrinks.Request.CreateNewCart;
import com.hmdrinks.Request.DeleteAllCartItemReq;
import com.hmdrinks.Response.CreateNewCartResponse;
import com.hmdrinks.Response.DeleteCartItemResponse;
import com.hmdrinks.Response.ListItemCartResponse;
import com.hmdrinks.Service.CartItemService;
import com.hmdrinks.Service.CartService;
import com.hmdrinks.Service.JwtService;
import com.hmdrinks.SupportFunction.SupportFunction;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@SecurityRequirement(name="bearerAuth")
@RequestMapping(value={"/api/cart"})
public class CartController {
    @Autowired
    private CartService cartService;
    @Autowired
    private CartItemService cartItemService;
    @Autowired
    private SupportFunction supportFunction;
    @Autowired
    private JwtService jwtService;

    @PostMapping(value={"/create"})
    public ResponseEntity<CreateNewCartResponse> create(@RequestBody CreateNewCart req, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(req.getUserId()));
        return ResponseEntity.ok((Object)this.cartService.createCart(req));
    }

    @GetMapping(value={"/list-caritem/{id}"})
    public ResponseEntity<ListItemCartResponse> listAllUser(@PathVariable Integer id) {
        return ResponseEntity.ok((Object)this.cartService.getAllItemCart(id.intValue()));
    }

    @DeleteMapping(value={"/delete-allItem/{id}"})
    public ResponseEntity<DeleteCartItemResponse> deleteAllItem(@RequestBody DeleteAllCartItemReq req, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(req.getUserId()));
        return ResponseEntity.ok((Object)this.cartItemService.deleteAllCartItem(req));
    }
}

