/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Controller;

import com.hmdrinks.Request.DeleteOneCartItemReq;
import com.hmdrinks.Request.IncreaseDecreaseItemQuantityReq;
import com.hmdrinks.Request.InsertItemToCart;
import com.hmdrinks.Response.CRUDCartItemResponse;
import com.hmdrinks.Response.DeleteCartItemResponse;
import com.hmdrinks.Response.IncreaseDecreaseItemQuantityResponse;
import com.hmdrinks.Service.CartItemService;
import com.hmdrinks.Service.JwtService;
import com.hmdrinks.SupportFunction.SupportFunction;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@SecurityRequirement(name="bearerAuth")
@RequestMapping(value={"/api/cart-item"})
public class CartItemController {
    @Autowired
    private CartItemService cartItemService;
    @Autowired
    private SupportFunction supportFunction;
    @Autowired
    private JwtService jwtService;

    @PostMapping(value={"/insert"})
    public ResponseEntity<CRUDCartItemResponse> create(@RequestBody InsertItemToCart req) {
        return ResponseEntity.ok((Object)this.cartItemService.insertCartItem(req));
    }

    @PutMapping(value={"/increase"})
    public ResponseEntity<IncreaseDecreaseItemQuantityResponse> create(@RequestBody IncreaseDecreaseItemQuantityReq req, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(req.getUserId()));
        return ResponseEntity.ok((Object)this.cartItemService.increaseCartItemQuantity(req));
    }

    @PutMapping(value={"/decrease"})
    public ResponseEntity<IncreaseDecreaseItemQuantityResponse> decreaseItemQuantityResponseResponseEntity(@RequestBody IncreaseDecreaseItemQuantityReq req, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(req.getUserId()));
        return ResponseEntity.ok((Object)this.cartItemService.decreaseCartItemQuantity(req));
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<DeleteCartItemResponse> deleteOneItem(@RequestBody DeleteOneCartItemReq req, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(req.getUserId()));
        return ResponseEntity.ok((Object)this.cartItemService.deleteOneItem(req));
    }
}

