/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Controller;

import com.hmdrinks.Request.CRUDCategoryRequest;
import com.hmdrinks.Request.CreateCategoryRequest;
import com.hmdrinks.Response.CRUDCategoryResponse;
import com.hmdrinks.Response.GetViewProductCategoryResponse;
import com.hmdrinks.Response.ListCategoryResponse;
import com.hmdrinks.Service.CategoryService;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@SecurityRequirement(name="bearerAuth")
@RequestMapping(value={"/api/cate"})
public class CategoryController {
    @Autowired
    private CategoryService categoryService;

    @GetMapping(value={"/list-category"})
    public ResponseEntity<ListCategoryResponse> listAllUser() {
        return ResponseEntity.ok((Object)this.categoryService.listCategory());
    }

    @PostMapping(value={"/create-category"})
    public ResponseEntity<CRUDCategoryResponse> createAccount(@RequestBody CreateCategoryRequest req) {
        return ResponseEntity.ok((Object)this.categoryService.crateCategory(req));
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<CRUDCategoryResponse> update(@RequestBody CRUDCategoryRequest req) {
        return ResponseEntity.ok((Object)this.categoryService.updateCategory(req));
    }

    @GetMapping(value={"/view/{id}"})
    public ResponseEntity<CRUDCategoryResponse> update(@PathVariable Integer id) {
        return ResponseEntity.ok((Object)this.categoryService.getOneCategory(id));
    }

    @GetMapping(value={"/view/{id}/product"})
    public ResponseEntity<GetViewProductCategoryResponse> view(@PathVariable Integer id) {
        return ResponseEntity.ok((Object)this.categoryService.getAllProductFromCategory(id.intValue()));
    }
}

