/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Controller;

import com.hmdrinks.Request.CRUDPostReq;
import com.hmdrinks.Request.CreateNewPostReq;
import com.hmdrinks.Response.CRUDPostResponse;
import com.hmdrinks.Response.ListAllPostByUserIdResponse;
import com.hmdrinks.Response.ListAllPostResponse;
import com.hmdrinks.Service.PostService;
import com.hmdrinks.SupportFunction.SupportFunction;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@SecurityRequirement(name="bearerAuth")
@RequestMapping(value={"/api/post"})
public class PostController {
    @Autowired
    private PostService postService;
    @Autowired
    private SupportFunction supportFunction;

    @PostMapping(value={"/create"})
    public ResponseEntity<CRUDPostResponse> createPost(@RequestBody CreateNewPostReq req, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(req.getUserId()));
        return ResponseEntity.ok((Object)this.postService.createPost(req));
    }

    @GetMapping(value={"/view/{id}"})
    public ResponseEntity<CRUDPostResponse> getOnePost(@PathVariable Integer id, HttpServletRequest httpRequest) {
        return ResponseEntity.ok((Object)this.postService.getPostById(id.intValue()));
    }

    @GetMapping(value={"/view/all"})
    public ResponseEntity<ListAllPostResponse> getAllPosts() {
        return ResponseEntity.ok((Object)this.postService.getAllPost());
    }

    @GetMapping(value={"/view/author/{userId}"})
    public ResponseEntity<ListAllPostByUserIdResponse> getOnePostByUserId(@PathVariable Integer userId) {
        return ResponseEntity.ok((Object)this.postService.listAllPostByUserId(userId.intValue()));
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<CRUDPostResponse> updatePost(@RequestBody CRUDPostReq req, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(req.getUserId()));
        return ResponseEntity.ok((Object)this.postService.updatePost(req));
    }
}

