/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Controller;

import com.hmdrinks.Request.ChangePasswordReq;
import com.hmdrinks.Request.UserInfoUpdateReq;
import com.hmdrinks.Response.GetDetailUserInfoResponse;
import com.hmdrinks.Response.UpdateUserInfoResponse;
import com.hmdrinks.Service.JwtService;
import com.hmdrinks.Service.UserService;
import com.hmdrinks.SupportFunction.SupportFunction;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@SecurityRequirement(name="bearerAuth")
@RequestMapping(value={"/api/user"})
public class UserController {
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private UserService userService;
    @Autowired
    private JwtService jwtService;
    @Autowired
    private SupportFunction supportFunction;

    @GetMapping(value={"/info/{id}"})
    public ResponseEntity<GetDetailUserInfoResponse> getDetailUserInfoResponseResponseEntity(@PathVariable Integer id, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(id.intValue()));
        return ResponseEntity.ok((Object)this.userService.getDetailUserInfoResponse(id));
    }

    @PutMapping(value={"/info-update"})
    public ResponseEntity<UpdateUserInfoResponse> updateUserInfoResponseResponseEntity(@RequestBody UserInfoUpdateReq req, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(req.getUserId().intValue()));
        return ResponseEntity.ok((Object)this.userService.updateUserInfoResponse(req));
    }

    @PutMapping(value={"/password/change"})
    public ResponseEntity<?> changePassword(@RequestBody ChangePasswordReq req, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(req.getUserId().intValue()));
        return ResponseEntity.ok((Object)this.userService.changePasswordResponse(req));
    }
}

