/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Controller;

import com.hmdrinks.Request.GetVoucherReq;
import com.hmdrinks.Response.GetVoucherResponse;
import com.hmdrinks.Response.ListAllVoucherUserIdResponse;
import com.hmdrinks.Service.UserVoucherService;
import com.hmdrinks.Service.VoucherService;
import com.hmdrinks.SupportFunction.SupportFunction;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@SecurityRequirement(name="bearerAuth")
@RequestMapping(value={"/api/user-voucher"})
public class UserVoucherController {
    @Autowired
    private UserVoucherService userVoucherService;
    @Autowired
    private SupportFunction supportFunction;
    @Autowired
    private VoucherService voucherService;

    @PostMapping(value={"/get-voucher"})
    public ResponseEntity<GetVoucherResponse> createVoucher(@RequestBody GetVoucherReq req, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(req.getUserId().intValue()));
        return ResponseEntity.ok((Object)this.userVoucherService.getVoucher(req));
    }

    @GetMapping(value={"/view-all/{id}"})
    public ResponseEntity<ListAllVoucherUserIdResponse> getAllVoucher(@PathVariable Integer id, HttpServletRequest httpRequest) {
        this.supportFunction.checkUserAuthorization(httpRequest, Long.valueOf(id.intValue()));
        return ResponseEntity.ok((Object)this.userVoucherService.listAllVoucherUserId(id.intValue()));
    }
}

