/*
 * Decompiled with CFR 0.152.
 */
package com.hmdrinks.Controller;

import com.hmdrinks.Request.CreateVoucherReq;
import com.hmdrinks.Request.CrudVoucherReq;
import com.hmdrinks.Response.CRUDVoucherResponse;
import com.hmdrinks.Response.ListAllVoucherResponse;
import com.hmdrinks.Service.VoucherService;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@SecurityRequirement(name="bearerAuth")
@RequestMapping(value={"/api/voucher"})
public class VoucherController {
    @Autowired
    private VoucherService voucherService;

    @PostMapping(value={"/create"})
    public ResponseEntity<CRUDVoucherResponse> createVoucher(@RequestBody CreateVoucherReq req) {
        return ResponseEntity.ok((Object)this.voucherService.createVoucher(req));
    }

    @GetMapping(value={"/view/{id}"})
    public ResponseEntity<CRUDVoucherResponse> getOneVoucher(@PathVariable Integer id, HttpServletRequest httpRequest) {
        return ResponseEntity.ok((Object)this.voucherService.getVoucherById(id.intValue()));
    }

    @GetMapping(value={"/view/all"})
    public ResponseEntity<ListAllVoucherResponse> getAllVouchers() {
        return ResponseEntity.ok((Object)this.voucherService.listAllVoucher());
    }

    @PutMapping(value={"/update"})
    public ResponseEntity<CRUDVoucherResponse> updatePost(@RequestBody CrudVoucherReq req, HttpServletRequest httpRequest) {
        return ResponseEntity.ok((Object)this.voucherService.updateVoucher(req));
    }
}

